/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.collection.primitive;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public final class PrimitiveLongCollections {
    private PrimitiveLongCollections() {
        throw new AssertionError((Object)"no instance");
    }

    public static PrimitiveIterator.OfLong range(long start, long end) {
        return new PrimitiveLongRangeIterator(start, end);
    }

    public static class PrimitiveLongRangeIterator
    extends PrimitiveLongBaseIterator {
        private long current;
        private final long end;

        PrimitiveLongRangeIterator(long start, long end) {
            this.current = start;
            this.end = end;
        }

        @Override
        protected boolean fetchNext() {
            try {
                boolean bl = this.current <= this.end && this.next(this.current);
                return bl;
            }
            finally {
                ++this.current;
            }
        }
    }

    public static abstract class PrimitiveLongBaseIterator
    implements PrimitiveIterator.OfLong {
        private boolean hasNextDecided;
        private boolean hasNext;
        protected long next;

        @Override
        public boolean hasNext() {
            if (!this.hasNextDecided) {
                this.hasNext = this.fetchNext();
                this.hasNextDecided = true;
            }
            return this.hasNext;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in " + this);
            }
            this.hasNextDecided = false;
            return this.next;
        }

        protected abstract boolean fetchNext();

        protected boolean next(long nextItem) {
            this.next = nextItem;
            this.hasNext = true;
            return true;
        }
    }
}

