/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import org.neo4j.gds.core.utils.TerminationFlagImpl;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;

public interface TerminationFlag {
    public static final TerminationFlag RUNNING_TRUE = () -> true;
    public static final int RUN_CHECK_NODE_COUNT = 10000;

    public static TerminationFlag wrap(KernelTransaction transaction) {
        return new TerminationFlagImpl(transaction);
    }

    public static TerminationFlag wrap(KernelTransaction transaction, long interval) {
        return new TerminationFlagImpl(transaction).withCheckInterval(interval);
    }

    public boolean running();

    default public void assertRunning() {
        if (!this.running()) {
            throw new TransactionTerminatedException((Status)Status.Transaction.Terminated);
        }
    }
}

