/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import com.carrotsearch.hppc.BitSet;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;

public class SetBitsIterable
implements Iterable<Long> {
    private final BitSet set;
    private final long offset;

    public SetBitsIterable(BitSet set, long offset) {
        this.set = set;
        this.offset = offset;
    }

    public SetBitsIterable(BitSet set) {
        this(set, 0L);
    }

    public PrimitiveIterator.OfLong iterator() {
        return new Iterator(this.offset);
    }

    public PrimitiveIterator.OfLong primitiveLongIterator() {
        return new PrimitiveLongIteratorWrapper(this.iterator());
    }

    public LongStream stream() {
        return StreamSupport.longStream(this.spliterator(), false);
    }

    public Spliterator.OfLong spliterator() {
        return Spliterators.spliterator(this.iterator(), this.set.cardinality(), 1301);
    }

    private static final class PrimitiveLongIteratorWrapper
    implements PrimitiveIterator.OfLong {
        private final PrimitiveIterator.OfLong nodeIterator;

        private PrimitiveLongIteratorWrapper(PrimitiveIterator.OfLong nodeIterator) {
            this.nodeIterator = nodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        @Override
        public long nextLong() {
            return this.nodeIterator.nextLong();
        }
    }

    private final class Iterator
    implements PrimitiveIterator.OfLong {
        long value;

        public Iterator(long index) {
            this.value = SetBitsIterable.this.set.nextSetBit(index);
        }

        @Override
        public boolean hasNext() {
            return this.value > -1L;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long returnValue = this.value;
            this.value = SetBitsIterable.this.set.nextSetBit(this.value + 1L);
            return returnValue;
        }
    }
}

