/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

public interface RenamesCurrentThread {
    public static final Revert EMPTY = () -> {};

    default public String threadName() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this);
    }

    public static Revert renameThread(String newThreadName) {
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        boolean renamed = false;
        if (!oldThreadName.equals(newThreadName)) {
            try {
                currentThread.setName(newThreadName);
                renamed = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (renamed) {
            return () -> currentThread.setName(oldThreadName);
        }
        return EMPTY;
    }

    public static interface Revert
    extends AutoCloseable {
        @Override
        public void close();
    }
}

