/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public class ProgressTimer
implements AutoCloseable {
    private final LongConsumer onStop;
    private final long startTime;
    private long duration = 0L;

    private ProgressTimer(LongConsumer onStop) {
        this.onStop = onStop == null ? l -> {} : onStop;
        this.startTime = System.nanoTime();
    }

    public ProgressTimer stop() {
        this.duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime);
        this.onStop.accept(this.duration);
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public static ProgressTimer start(LongConsumer onStop) {
        return new ProgressTimer(onStop);
    }

    public static ProgressTimer start() {
        return new ProgressTimer(null);
    }

    @Override
    public void close() {
        this.stop();
    }
}

