/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayList;
import java.util.Arrays;
import java.util.function.LongPredicate;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.utils.ImmutablePageOrdering;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class PageReordering {
    private static final long ZERO_DEGREE_OFFSET = 0L;

    public static <PAGE> void reorder(PAGE[] pages, HugeLongArray offsets, HugeIntArray degrees) {
        PageOrdering ordering = PageReordering.ordering(offsets, nodeId -> degrees.get(nodeId) > 0, pages.length, 18);
        PageReordering.reorder(pages, ordering.distinctOrdering());
        PageReordering.rewriteOffsets(offsets, ordering, node -> degrees.get(node) > 0, 18);
    }

    static PageOrdering ordering(HugeLongArray offsets, LongPredicate nodeFilter, int pageCount, int pageShift) {
        HugeCursor<long[]> cursor = offsets.initCursor(offsets.newCursor());
        LongArrayList pageOffsets = new LongArrayList(pageCount + 1);
        IntArrayList ordering = new IntArrayList(pageCount);
        int[] distinctOrdering = new int[pageCount];
        int[] reverseDistinctOrdering = new int[pageCount];
        int orderedIdx = 0;
        int prevPageIdx = -1;
        BitSet seenPages = new BitSet((long)pageCount);
        while (cursor.next()) {
            long[] offsetArray = (long[])cursor.array;
            int limit = cursor.limit;
            long base = cursor.base;
            for (int i = cursor.offset; i < limit; ++i) {
                long offset;
                int pageIdx;
                long nodeId = base + (long)i;
                if (!nodeFilter.test(nodeId) || (pageIdx = (int)((offset = offsetArray[i]) >>> pageShift)) == prevPageIdx) continue;
                if (!seenPages.getAndSet(pageIdx)) {
                    distinctOrdering[orderedIdx] = pageIdx;
                    reverseDistinctOrdering[pageIdx] = orderedIdx++;
                }
                ordering.add(reverseDistinctOrdering[pageIdx]);
                pageOffsets.add(nodeId);
                prevPageIdx = pageIdx;
            }
        }
        pageOffsets.add(offsets.size());
        return ImmutablePageOrdering.builder().distinctOrdering(distinctOrdering).reverseOrdering(ordering.buffer).length(ordering.elementsCount).pageOffsets(pageOffsets.buffer).build();
    }

    static <PAGE> int[] reorder(PAGE[] pages, int[] ordering) {
        int[] swaps = new int[pages.length];
        Arrays.setAll(swaps, i -> -i - 1);
        for (int targetIdx = 0; targetIdx < ordering.length; ++targetIdx) {
            int sourceIdx = ordering[targetIdx];
            int swapTargetIdx = swaps[targetIdx];
            assert (swapTargetIdx < 0) : "target page has already been set";
            int swapSourceIdx = sourceIdx;
            while (swaps[swapSourceIdx] >= 0) {
                swapSourceIdx = swaps[swapSourceIdx];
            }
            assert (swaps[swapSourceIdx] == -sourceIdx - 1) : "source page has already been moved";
            if (swapSourceIdx == targetIdx) {
                swaps[targetIdx] = sourceIdx;
                continue;
            }
            PAGE tempPage = pages[targetIdx];
            pages[targetIdx] = pages[swapSourceIdx];
            pages[swapSourceIdx] = tempPage;
            swaps[targetIdx] = sourceIdx;
            swaps[swapSourceIdx] = swapTargetIdx;
        }
        return swaps;
    }

    static void rewriteOffsets(HugeLongArray offsets, PageOrdering pageOrdering, LongPredicate nodeFilter, int pageShift) {
        long pageMask = (1L << pageShift) - 1L;
        long[] pageOffsets = pageOrdering.pageOffsets();
        try (HugeCursor<long[]> cursor = offsets.newCursor();){
            int[] ordering = pageOrdering.reverseOrdering();
            int length = pageOrdering.length();
            for (int i = 0; i < length; ++i) {
                long newPageId = (long)ordering[i] << pageShift;
                long startIdx = pageOffsets[i];
                long endIdx = pageOffsets[i + 1];
                offsets.initCursor(cursor, startIdx, endIdx);
                while (cursor.next()) {
                    long[] array = (long[])cursor.array;
                    int limit = cursor.limit;
                    long baseNodeId = cursor.base;
                    for (int j = cursor.offset; j < limit; ++j) {
                        array[j] = nodeFilter.test(baseNodeId + (long)j) ? array[j] & pageMask | newPageId : 0L;
                    }
                }
            }
        }
    }

    private PageReordering() {
    }

    @ValueClass
    public static interface PageOrdering {
        public int[] distinctOrdering();

        public int[] reverseOrdering();

        public long[] pageOffsets();

        public int length();

        @TestOnly
        default public int[] shrinkToFitReverseOrdering() {
            return Arrays.copyOf(this.reverseOrdering(), this.length());
        }

        @TestOnly
        default public long[] shrinkToFitPageOffsets() {
            return Arrays.copyOf(this.pageOffsets(), this.length() + 1);
        }
    }
}

