/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public final class LazyMappingCollection<T, U>
extends AbstractCollection<U> {
    private final Collection<T> base;
    private final Function<T, U> mappingFunction;

    public static <T, U> Collection<U> of(Collection<T> base, Function<T, U> mappingFunction) {
        return new LazyMappingCollection<T, U>(base, mappingFunction);
    }

    private LazyMappingCollection(Collection<T> base, Function<T, U> mappingFunction) {
        this.base = base;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public Iterator<U> iterator() {
        return new AbstractIterator<U>(){
            private final Iterator<T> it;
            {
                this.it = LazyMappingCollection.this.base.iterator();
            }

            protected U fetch() {
                if (this.it.hasNext()) {
                    return LazyMappingCollection.this.mappingFunction.apply(this.it.next());
                }
                return this.done();
            }
        };
    }

    @Override
    public int size() {
        return this.base.size();
    }
}

