/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongLookupContainer;

public final class Intersections {
    public static long intersection(LongHashSet targets1, LongHashSet targets2) {
        LongHashSet intersectionSet = new LongHashSet((LongContainer)targets1);
        intersectionSet.retainAll((LongLookupContainer)targets2);
        return intersectionSet.size();
    }

    public static long intersection2(long[] targets1, long[] targets2) {
        LongHashSet intersectionSet = LongHashSet.from((long[])targets1);
        intersectionSet.retainAll((LongLookupContainer)LongHashSet.from((long[])targets2));
        return intersectionSet.size();
    }

    public static long intersection3(long[] targets1, long[] targets2) {
        int len2 = targets2.length;
        if (len2 == 0) {
            return 0L;
        }
        int off2 = 0;
        long intersection = 0L;
        for (long value1 : targets1) {
            if (value1 > targets2[off2]) {
                while (++off2 != len2 && value1 > targets2[off2]) {
                }
                if (off2 == len2) {
                    return intersection;
                }
            }
            if (value1 != targets2[off2]) continue;
            ++intersection;
            if (++off2 != len2) continue;
            return intersection;
        }
        return intersection;
    }

    public static long intersection4(long[] targets1, long[] targets2) {
        if (targets2.length == 0) {
            return 0L;
        }
        int off2 = 0;
        long intersection = 0L;
        for (int off1 = 0; off1 < targets1.length; ++off1) {
            if (off2 == targets2.length) {
                return intersection;
            }
            long value1 = targets1[off1];
            if (value1 > targets2[off2]) {
                while (off2 < targets2.length && value1 > targets2[off2]) {
                    ++off2;
                }
                if (off2 == targets2.length) {
                    return intersection;
                }
            }
            if (value1 != targets2[off2]) continue;
            ++intersection;
            ++off2;
        }
        return intersection;
    }

    public static double sumSquareDelta(double[] vector1, double[] vector2, int len) {
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double delta = vector1[i] - vector2[i];
            result += delta * delta;
        }
        return result;
    }

    public static float sumSquareDelta(float[] vector1, float[] vector2, int len) {
        float result = 0.0f;
        for (int i = 0; i < len; ++i) {
            float delta = vector1[i] - vector2[i];
            result += delta * delta;
        }
        return result;
    }

    public static double[] sumSquareDeltas(double[] vector1, double[][] vector2, int len) {
        int vectors = vector2.length;
        double[] result = new double[vectors];
        for (int i = 0; i < len; ++i) {
            double v1 = vector1[i];
            for (int j = 0; j < vectors; ++j) {
                int n = j;
                result[n] = result[n] + (v1 - vector2[j][i]) * (v1 - vector2[j][i]);
            }
        }
        return result;
    }

    public static double pearson(double[] vector1, double[] vector2, int len) {
        double vector1Sum = 0.0;
        double vector2Sum = 0.0;
        for (int i = 0; i < len; ++i) {
            vector1Sum += vector1[i];
            vector2Sum += vector2[i];
        }
        double vector1Mean = vector1Sum / (double)len;
        double vector2Mean = vector2Sum / (double)len;
        double dotProductMinusMean = 0.0;
        double xLength = 0.0;
        double yLength = 0.0;
        for (int i = 0; i < len; ++i) {
            double vector1Delta = vector1[i] - vector1Mean;
            double vector2Delta = vector2[i] - vector2Mean;
            dotProductMinusMean += vector1Delta * vector2Delta;
            xLength += vector1Delta * vector1Delta;
            yLength += vector2Delta * vector2Delta;
        }
        double result = dotProductMinusMean / Math.sqrt(xLength * yLength);
        return Double.isNaN(result) ? 0.0 : result;
    }

    public static double cosine(double[] vector1, double[] vector2, int len) {
        double dotProduct = 0.0;
        double xLength = 0.0;
        double yLength = 0.0;
        for (int i = 0; i < len; ++i) {
            double weight1 = vector1[i];
            double weight2 = vector2[i];
            dotProduct += weight1 * weight2;
            xLength += weight1 * weight1;
            yLength += weight2 * weight2;
        }
        return dotProduct / Math.sqrt(xLength * yLength);
    }

    public static float cosine(float[] vector1, float[] vector2, int len) {
        float dotProduct = 0.0f;
        float xLength = 0.0f;
        float yLength = 0.0f;
        for (int i = 0; i < len; ++i) {
            float weight1 = vector1[i];
            float weight2 = vector2[i];
            dotProduct += weight1 * weight2;
            xLength += weight1 * weight1;
            yLength += weight2 * weight2;
        }
        return (float)((double)dotProduct / Math.sqrt(xLength * yLength));
    }
}

