/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.PageReordering;

@ParametersAreNonnullByDefault
@Generated(from="PageReordering.PageOrdering", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutablePageOrdering
implements PageReordering.PageOrdering {
    private final int[] distinctOrdering;
    private final int[] reverseOrdering;
    private final long[] pageOffsets;
    private final int length;

    private ImmutablePageOrdering(int[] distinctOrdering, int[] reverseOrdering, long[] pageOffsets, int length) {
        this.distinctOrdering = (int[])distinctOrdering.clone();
        this.reverseOrdering = (int[])reverseOrdering.clone();
        this.pageOffsets = (long[])pageOffsets.clone();
        this.length = length;
    }

    private ImmutablePageOrdering(ImmutablePageOrdering original, int[] distinctOrdering, int[] reverseOrdering, long[] pageOffsets, int length) {
        this.distinctOrdering = distinctOrdering;
        this.reverseOrdering = reverseOrdering;
        this.pageOffsets = pageOffsets;
        this.length = length;
    }

    @Override
    public int[] distinctOrdering() {
        return (int[])this.distinctOrdering.clone();
    }

    @Override
    public int[] reverseOrdering() {
        return (int[])this.reverseOrdering.clone();
    }

    @Override
    public long[] pageOffsets() {
        return (long[])this.pageOffsets.clone();
    }

    @Override
    public int length() {
        return this.length;
    }

    public final ImmutablePageOrdering withDistinctOrdering(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutablePageOrdering(this, newValue, this.reverseOrdering, this.pageOffsets, this.length);
    }

    public final ImmutablePageOrdering withReverseOrdering(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutablePageOrdering(this, this.distinctOrdering, newValue, this.pageOffsets, this.length);
    }

    public final ImmutablePageOrdering withPageOffsets(long ... elements) {
        long[] newValue = (long[])elements.clone();
        return new ImmutablePageOrdering(this, this.distinctOrdering, this.reverseOrdering, newValue, this.length);
    }

    public final ImmutablePageOrdering withLength(int value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutablePageOrdering(this, this.distinctOrdering, this.reverseOrdering, this.pageOffsets, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageOrdering && this.equalTo((ImmutablePageOrdering)another);
    }

    private boolean equalTo(ImmutablePageOrdering another) {
        return Arrays.equals(this.distinctOrdering, another.distinctOrdering) && Arrays.equals(this.reverseOrdering, another.reverseOrdering) && Arrays.equals(this.pageOffsets, another.pageOffsets) && this.length == another.length;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.distinctOrdering);
        h += (h << 5) + Arrays.hashCode(this.reverseOrdering);
        h += (h << 5) + Arrays.hashCode(this.pageOffsets);
        h += (h << 5) + this.length;
        return h;
    }

    public String toString() {
        return "PageOrdering{distinctOrdering=" + Arrays.toString(this.distinctOrdering) + ", reverseOrdering=" + Arrays.toString(this.reverseOrdering) + ", pageOffsets=" + Arrays.toString(this.pageOffsets) + ", length=" + this.length + "}";
    }

    public static PageReordering.PageOrdering of(int[] distinctOrdering, int[] reverseOrdering, long[] pageOffsets, int length) {
        return new ImmutablePageOrdering(distinctOrdering, reverseOrdering, pageOffsets, length);
    }

    public static PageReordering.PageOrdering copyOf(PageReordering.PageOrdering instance) {
        if (instance instanceof ImmutablePageOrdering) {
            return (ImmutablePageOrdering)instance;
        }
        return ImmutablePageOrdering.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PageReordering.PageOrdering", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DISTINCT_ORDERING = 1L;
        private static final long INIT_BIT_REVERSE_ORDERING = 2L;
        private static final long INIT_BIT_PAGE_OFFSETS = 4L;
        private static final long INIT_BIT_LENGTH = 8L;
        private long initBits = 15L;
        @Nullable
        private int[] distinctOrdering;
        @Nullable
        private int[] reverseOrdering;
        @Nullable
        private long[] pageOffsets;
        private int length;

        private Builder() {
        }

        public final Builder from(PageReordering.PageOrdering instance) {
            Objects.requireNonNull(instance, "instance");
            this.distinctOrdering(instance.distinctOrdering());
            this.reverseOrdering(instance.reverseOrdering());
            this.pageOffsets(instance.pageOffsets());
            this.length(instance.length());
            return this;
        }

        public final Builder distinctOrdering(int ... distinctOrdering) {
            this.distinctOrdering = (int[])distinctOrdering.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reverseOrdering(int ... reverseOrdering) {
            this.reverseOrdering = (int[])reverseOrdering.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder pageOffsets(long ... pageOffsets) {
            this.pageOffsets = (long[])pageOffsets.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder length(int length) {
            this.length = length;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.distinctOrdering = null;
            this.reverseOrdering = null;
            this.pageOffsets = null;
            this.length = 0;
            return this;
        }

        public PageReordering.PageOrdering build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageOrdering(null, this.distinctOrdering, this.reverseOrdering, this.pageOffsets, this.length);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("distinctOrdering");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reverseOrdering");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pageOffsets");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("length");
            }
            return "Cannot build PageOrdering, some of required attributes are not set " + attributes;
        }
    }
}

