/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.ArrayLayout;

@ParametersAreNonnullByDefault
@Generated(from="ArrayLayout.LayoutAndSecondary", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableLayoutAndSecondary
implements ArrayLayout.LayoutAndSecondary {
    private final long[] layout;
    private final int[] secondary;

    private ImmutableLayoutAndSecondary(long[] layout, int[] secondary) {
        this.layout = (long[])layout.clone();
        this.secondary = (int[])secondary.clone();
    }

    private ImmutableLayoutAndSecondary(ImmutableLayoutAndSecondary original, long[] layout, int[] secondary) {
        this.layout = layout;
        this.secondary = secondary;
    }

    @Override
    public long[] layout() {
        return (long[])this.layout.clone();
    }

    @Override
    public int[] secondary() {
        return (int[])this.secondary.clone();
    }

    public final ImmutableLayoutAndSecondary withLayout(long ... elements) {
        long[] newValue = (long[])elements.clone();
        return new ImmutableLayoutAndSecondary(this, newValue, this.secondary);
    }

    public final ImmutableLayoutAndSecondary withSecondary(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableLayoutAndSecondary(this, this.layout, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLayoutAndSecondary && this.equalTo((ImmutableLayoutAndSecondary)another);
    }

    private boolean equalTo(ImmutableLayoutAndSecondary another) {
        return Arrays.equals(this.layout, another.layout) && Arrays.equals(this.secondary, another.secondary);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.layout);
        h += (h << 5) + Arrays.hashCode(this.secondary);
        return h;
    }

    public String toString() {
        return "LayoutAndSecondary{layout=" + Arrays.toString(this.layout) + ", secondary=" + Arrays.toString(this.secondary) + "}";
    }

    public static ArrayLayout.LayoutAndSecondary of(long[] layout, int[] secondary) {
        return new ImmutableLayoutAndSecondary(layout, secondary);
    }

    public static ArrayLayout.LayoutAndSecondary copyOf(ArrayLayout.LayoutAndSecondary instance) {
        if (instance instanceof ImmutableLayoutAndSecondary) {
            return (ImmutableLayoutAndSecondary)instance;
        }
        return ImmutableLayoutAndSecondary.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ArrayLayout.LayoutAndSecondary", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LAYOUT = 1L;
        private static final long INIT_BIT_SECONDARY = 2L;
        private long initBits = 3L;
        @Nullable
        private long[] layout;
        @Nullable
        private int[] secondary;

        private Builder() {
        }

        public final Builder from(ArrayLayout.LayoutAndSecondary instance) {
            Objects.requireNonNull(instance, "instance");
            this.layout(instance.layout());
            this.secondary(instance.secondary());
            return this;
        }

        public final Builder layout(long ... layout) {
            this.layout = (long[])layout.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder secondary(int ... secondary) {
            this.secondary = (int[])secondary.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.layout = null;
            this.secondary = null;
            return this;
        }

        public ArrayLayout.LayoutAndSecondary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLayoutAndSecondary(null, this.layout, this.secondary);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("layout");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("secondary");
            }
            return "Cannot build LayoutAndSecondary, some of required attributes are not set " + attributes;
        }
    }
}

