/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import java.util.Arrays;
import org.neo4j.gds.utils.GdsFeatureToggles;

public final class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = 1 << GdsFeatureToggles.MAX_ARRAY_LENGTH_SHIFT.get();
    public static final int LINEAR_SEARCH_LIMIT = 64;

    public static boolean binarySearch(int[] arr, int length, int key) {
        int low = 0;
        int high = length - 1;
        while (high - low > 64) {
            int mid = low + high >>> 1;
            int midVal = arr[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return ArrayUtil.linearSearch2(arr, low, high, key);
    }

    public static int binarySearchFirst(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            if (mid > 0 && a[mid - 1] == key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearchLast(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            if (mid < toIndex - 1 && a[mid + 1] == key) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearchIndex(int[] arr, int length, int key) {
        int low = 0;
        int high = length - 1;
        while (high - low > 64) {
            int mid = low + high >>> 1;
            int midVal = arr[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return ArrayUtil.linearSearch2index(arr, low, high, key);
    }

    public static boolean linearSearch2(int[] arr, int low, int high, int key) {
        for (int i = low; i <= high; ++i) {
            if (arr[i] == key) {
                return true;
            }
            if (arr[i] <= key) continue;
            return false;
        }
        return false;
    }

    public static int linearSearch2index(int[] arr, int low, int high, int key) {
        for (int i = low; i <= high; ++i) {
            if (arr[i] == key) {
                return i;
            }
            if (arr[i] <= key) continue;
            return -i - 1;
        }
        return -high - 1;
    }

    public static boolean linearSearch(int[] arr, int length, int key) {
        int i;
        for (i = 0; i < length - 4; i += 4) {
            if (arr[i] == key) {
                return true;
            }
            if (arr[i + 1] == key) {
                return true;
            }
            if (arr[i + 2] == key) {
                return true;
            }
            if (arr[i + 3] != key) continue;
            return true;
        }
        while (i < length) {
            if (arr[i] == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int linearSearchIndex(int[] arr, int length, int key) {
        int i;
        for (i = 0; i < length - 4; i += 4) {
            if (arr[i] == key) {
                return i;
            }
            if (arr[i + 1] == key) {
                return i + 1;
            }
            if (arr[i + 2] == key) {
                return i + 2;
            }
            if (arr[i + 3] != key) continue;
            return i + 3;
        }
        while (i < length) {
            if (arr[i] == key) {
                return i;
            }
            ++i;
        }
        return -length - 1;
    }

    private static boolean linearSearch(int[] arr, int low, int high, int key) {
        int i;
        for (i = low; i < high - 3; i += 4) {
            if (arr[i] > key) {
                return false;
            }
            if (arr[i] == key) {
                return true;
            }
            if (arr[i + 1] == key) {
                return true;
            }
            if (arr[i + 2] == key) {
                return true;
            }
            if (arr[i + 3] != key) continue;
            return true;
        }
        while (i <= high) {
            if (arr[i] == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int binaryLookup(long id, long[] ids) {
        int length = ids.length;
        int low = 0;
        int high = length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = ids[mid];
            if (midVal < id) {
                low = mid + 1;
                continue;
            }
            if (midVal > id) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    public static double[] fill(double value, int length) {
        double[] data = new double[length];
        Arrays.fill(data, value);
        return data;
    }

    public static boolean contains(long[] array, long value) {
        for (long l : array) {
            if (l != value) continue;
            return true;
        }
        return false;
    }

    private ArrayUtil() {
        throw new UnsupportedOperationException("No instances");
    }
}

