/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import java.util.Objects;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.utils.ImmutableLayoutAndSecondary;

public final class ArrayLayout {
    public static long[] constructEytzinger(long[] input) {
        return ArrayLayout.constructEytzinger(input, 0, input.length);
    }

    public static long[] constructEytzinger(long[] input, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, input.length);
        long[] dest = new long[length + 1];
        dest[0] = -1L;
        ArrayLayout.eytzinger(length, input, dest, offset, 1);
        return dest;
    }

    public static LayoutAndSecondary constructEytzinger(long[] input, int[] secondary) {
        if (secondary.length != input.length) {
            throw new IllegalArgumentException("Input arrays must be of same length");
        }
        long[] dest = new long[input.length + 1];
        dest[0] = -1L;
        int[] secondaryDest = new int[secondary.length];
        ArrayLayout.eytzingerWithSecondary(input.length, input, dest, 0, 1, secondary, secondaryDest);
        return ImmutableLayoutAndSecondary.of(dest, secondaryDest);
    }

    private static int eytzinger(int length, long[] source, long[] dest, int sourceIndex, int destIndex) {
        if (destIndex <= length) {
            sourceIndex = ArrayLayout.eytzinger(length, source, dest, sourceIndex, 2 * destIndex);
            dest[destIndex] = source[sourceIndex++];
            sourceIndex = ArrayLayout.eytzinger(length, source, dest, sourceIndex, 2 * destIndex + 1);
        }
        return sourceIndex;
    }

    private static int eytzingerWithSecondary(int length, long[] source, long[] dest, int sourceIndex, int destIndex, int[] secondarySource, int[] secondaryDest) {
        if (destIndex <= length) {
            sourceIndex = ArrayLayout.eytzingerWithSecondary(length, source, dest, sourceIndex, 2 * destIndex, secondarySource, secondaryDest);
            secondaryDest[destIndex - 1] = secondarySource[sourceIndex];
            dest[destIndex] = source[sourceIndex++];
            sourceIndex = ArrayLayout.eytzingerWithSecondary(length, source, dest, sourceIndex, 2 * destIndex + 1, secondarySource, secondaryDest);
        }
        return sourceIndex;
    }

    public static int searchEytzinger(long[] haystack, long needle) {
        int index = 1;
        int length = haystack.length - 1;
        while (index <= length) {
            index = needle < haystack[index] ? index << 1 : (index << 1) + 1;
        }
        return index >>> 1 + Integer.numberOfTrailingZeros(index);
    }

    private ArrayLayout() {
    }

    @ValueClass
    public static interface LayoutAndSecondary {
        public long[] layout();

        public int[] secondary();
    }
}

