/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.nodeproperties;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.HugeSparseCollections;
import org.neo4j.gds.core.loading.ValueConverter;
import org.neo4j.gds.core.loading.nodeproperties.DoubleArrayNodePropertiesBuilder;
import org.neo4j.gds.core.loading.nodeproperties.DoubleNodePropertiesBuilder;
import org.neo4j.gds.core.loading.nodeproperties.FloatArrayNodePropertiesBuilder;
import org.neo4j.gds.core.loading.nodeproperties.InnerNodePropertiesBuilder;
import org.neo4j.gds.core.loading.nodeproperties.LongArrayNodePropertiesBuilder;
import org.neo4j.gds.core.loading.nodeproperties.LongNodePropertiesBuilder;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class NodePropertiesFromStoreBuilder {
    private static final MemoryEstimation MEMORY_ESTIMATION = MemoryEstimations.builder(NodePropertiesFromStoreBuilder.class).rangePerGraphDimension("property values", (dimensions, concurrency) -> HugeSparseCollections.estimateLong((long)dimensions.nodeCount(), (long)dimensions.nodeCount())).build();
    private final DefaultValue defaultValue;
    private final int concurrency;
    private final AtomicReference<InnerNodePropertiesBuilder> innerBuilder;
    private final LongAdder size;

    public static MemoryEstimation memoryEstimation() {
        return MEMORY_ESTIMATION;
    }

    public static NodePropertiesFromStoreBuilder of(DefaultValue defaultValue, int concurrency) {
        return new NodePropertiesFromStoreBuilder(defaultValue, concurrency);
    }

    private NodePropertiesFromStoreBuilder(DefaultValue defaultValue, int concurrency) {
        this.defaultValue = defaultValue;
        this.concurrency = concurrency;
        this.innerBuilder = new AtomicReference();
        this.size = new LongAdder();
    }

    public void set(long neoNodeId, Value value) {
        if (value != null && value != Values.NO_VALUE) {
            if (this.innerBuilder.get() == null) {
                this.initializeWithType(value);
            }
            this.innerBuilder.get().setValue(neoNodeId, value);
            this.size.increment();
        }
    }

    public NodePropertyValues build(IdMap idMap) {
        if (this.innerBuilder.get() == null) {
            if (this.defaultValue.getObject() != null) {
                this.initializeWithType(Values.of((Object)this.defaultValue.getObject()));
            } else {
                throw new IllegalStateException("Cannot infer type of property");
            }
        }
        return this.innerBuilder.get().build(this.size.sum(), idMap);
    }

    private synchronized void initializeWithType(Value value) {
        if (this.innerBuilder.get() == null) {
            ValueType valueType = ValueConverter.valueType(value);
            InnerNodePropertiesBuilder newBuilder = this.newInnerBuilder(valueType);
            this.innerBuilder.compareAndSet(null, newBuilder);
        }
    }

    private InnerNodePropertiesBuilder newInnerBuilder(ValueType valueType) {
        switch (valueType) {
            case LONG: {
                return LongNodePropertiesBuilder.of(this.defaultValue, this.concurrency);
            }
            case DOUBLE: {
                return new DoubleNodePropertiesBuilder(this.defaultValue, this.concurrency);
            }
            case DOUBLE_ARRAY: {
                return new DoubleArrayNodePropertiesBuilder(this.defaultValue, this.concurrency);
            }
            case FLOAT_ARRAY: {
                return new FloatArrayNodePropertiesBuilder(this.defaultValue, this.concurrency);
            }
            case LONG_ARRAY: {
                return new LongArrayNodePropertiesBuilder(this.defaultValue, this.concurrency);
            }
        }
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Loading of values of type %s is currently not supported", (Object[])new Object[]{valueType}));
    }
}

