/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.nodeproperties;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseLongArray;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.nodeproperties.InnerNodePropertiesBuilder;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class LongNodePropertiesBuilder
extends InnerNodePropertiesBuilder {
    private volatile long maxValue;
    private static final VarHandle MAX_VALUE;
    private final HugeSparseLongArray.Builder builder;
    private final long defaultValue;
    private final int concurrency;

    private LongNodePropertiesBuilder(HugeSparseLongArray.Builder builder, long defaultValue, int concurrency) {
        this.builder = builder;
        this.defaultValue = defaultValue;
        this.concurrency = concurrency;
        this.maxValue = Long.MIN_VALUE;
    }

    public static LongNodePropertiesBuilder of(DefaultValue defaultValue, int concurrency) {
        long defaultLongValue = defaultValue.longValue();
        HugeSparseLongArray.Builder builder = HugeSparseLongArray.builder((long)defaultLongValue);
        return new LongNodePropertiesBuilder(builder, defaultLongValue, concurrency);
    }

    @Override
    protected Class<?> valueClass() {
        return Long.TYPE;
    }

    public void set(long neoNodeId, long value) {
        this.builder.set(neoNodeId, value);
        this.updateMaxValue(value);
    }

    @Override
    public void setValue(long neoNodeId, Value value) {
        long longValue = Neo4jValueConversion.getLongValue(value);
        this.set(neoNodeId, longValue);
    }

    @Override
    public NodePropertyValues buildDirect(long size) {
        return new LongStoreNodePropertyValues(this.builder.build(), size, OptionalLong.empty());
    }

    @Override
    public NodePropertyValues build(long size, IdMap idMap) {
        HugeSparseLongArray propertiesByNeoIds = this.builder.build();
        HugeSparseLongArray.Builder propertiesByMappedIdsBuilder = HugeSparseLongArray.builder((long)this.defaultValue);
        DrainingIterator drainingIterator = propertiesByNeoIds.drainingIterator();
        List tasks = IntStream.range(0, this.concurrency).mapToObj(threadId -> () -> {
            DrainingIterator.DrainingBatch batch = drainingIterator.drainingBatch();
            while (drainingIterator.next(batch)) {
                long[] page = (long[])batch.page;
                long offset = batch.offset;
                long end = Math.min(offset + (long)page.length, idMap.highestNeoId() + 1L) - offset;
                int pageIndex = 0;
                while ((long)pageIndex < end) {
                    long value;
                    long neoId = offset + (long)pageIndex;
                    long mappedId = idMap.toMappedNodeId(neoId);
                    if (mappedId != -1L && (value = page[pageIndex]) != this.defaultValue) {
                        propertiesByMappedIdsBuilder.set(mappedId, value);
                    }
                    ++pageIndex;
                }
            }
        }).collect(Collectors.toList());
        ParallelUtil.run(tasks, Pools.DEFAULT);
        HugeSparseLongArray propertyValues = propertiesByMappedIdsBuilder.build();
        OptionalLong maybeMaxValue = size > 0L ? OptionalLong.of(MAX_VALUE.getVolatile(this)) : OptionalLong.empty();
        return new LongStoreNodePropertyValues(propertyValues, size, maybeMaxValue);
    }

    private void updateMaxValue(long value) {
        long currentMax = MAX_VALUE.getOpaque(this);
        if (currentMax >= value) {
            return;
        }
        while (currentMax < value) {
            long newMax = MAX_VALUE.compareAndExchange(this, currentMax, value);
            if (newMax == currentMax) {
                return;
            }
            currentMax = newMax;
        }
    }

    static {
        VarHandle maxValueHandle;
        try {
            maxValueHandle = MethodHandles.lookup().findVarHandle(LongNodePropertiesBuilder.class, "maxValue", Long.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        MAX_VALUE = maxValueHandle;
    }

    static class LongStoreNodePropertyValues
    implements LongNodePropertyValues {
        private final HugeSparseLongArray propertyValues;
        private final long size;
        private final OptionalLong maxValue;

        LongStoreNodePropertyValues(HugeSparseLongArray propertyValues, long size, OptionalLong maxValue) {
            this.propertyValues = propertyValues;
            this.size = size;
            this.maxValue = maxValue;
        }

        @Override
        public long longValue(long nodeId) {
            return this.propertyValues.get(nodeId);
        }

        @Override
        public OptionalLong getMaxLongPropertyValue() {
            return this.maxValue;
        }

        @Override
        public long size() {
            return this.size;
        }
    }
}

