/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.nodeproperties;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.LongArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseLongArrayArray;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.nodeproperties.InnerNodePropertiesBuilder;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class LongArrayNodePropertiesBuilder
extends InnerNodePropertiesBuilder {
    private final HugeSparseLongArrayArray.Builder builder;
    private final long[] defaultValue;
    private final int concurrency;

    public LongArrayNodePropertiesBuilder(DefaultValue defaultValue, int concurrency) {
        this.defaultValue = defaultValue.longArrayValue();
        this.concurrency = concurrency;
        this.builder = HugeSparseLongArrayArray.builder((long[])this.defaultValue);
    }

    public void set(long neoNodeId, long[] value) {
        this.builder.set(neoNodeId, value);
    }

    @Override
    protected Class<?> valueClass() {
        return long[].class;
    }

    @Override
    public void setValue(long neoNodeId, Value value) {
        this.set(neoNodeId, Neo4jValueConversion.getLongArray(value));
    }

    public void setValue(long nodeId, long[] value) {
        this.builder.set(nodeId, value);
    }

    @Override
    public NodePropertyValues buildDirect(long size) {
        return new LongArrayStoreNodePropertyValues(this.builder.build(), size);
    }

    @Override
    public LongArrayNodePropertyValues build(long size, IdMap idMap) {
        HugeSparseLongArrayArray propertiesByNeoIds = this.builder.build();
        HugeSparseLongArrayArray.Builder propertiesByMappedIdsBuilder = HugeSparseLongArrayArray.builder((long[])this.defaultValue);
        DrainingIterator drainingIterator = propertiesByNeoIds.drainingIterator();
        List tasks = IntStream.range(0, this.concurrency).mapToObj(threadId -> () -> {
            DrainingIterator.DrainingBatch batch = drainingIterator.drainingBatch();
            while (drainingIterator.next(batch)) {
                long[][] page = (long[][])batch.page;
                long offset = batch.offset;
                long end = Math.min(offset + (long)page.length, idMap.highestNeoId() + 1L) - offset;
                int pageIndex = 0;
                while ((long)pageIndex < end) {
                    long[] value;
                    long neoId = offset + (long)pageIndex;
                    long mappedId = idMap.toMappedNodeId(neoId);
                    if (!(mappedId == -1L || (value = page[pageIndex]) == null || this.defaultValue != null && Arrays.equals(value, this.defaultValue))) {
                        propertiesByMappedIdsBuilder.set(mappedId, value);
                    }
                    ++pageIndex;
                }
            }
        }).collect(Collectors.toList());
        ParallelUtil.run(tasks, Pools.DEFAULT);
        HugeSparseLongArrayArray propertyValues = propertiesByMappedIdsBuilder.build();
        return new LongArrayStoreNodePropertyValues(propertyValues, size);
    }

    static class LongArrayStoreNodePropertyValues
    implements LongArrayNodePropertyValues {
        private final HugeSparseLongArrayArray propertyValues;
        private final long size;

        LongArrayStoreNodePropertyValues(HugeSparseLongArrayArray propertyValues, long size) {
            this.propertyValues = propertyValues;
            this.size = size;
        }

        @Override
        public long[] longArrayValue(long nodeId) {
            return this.propertyValues.get(nodeId);
        }

        @Override
        public long size() {
            return this.size;
        }
    }
}

