/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.nodeproperties;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.FloatArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseFloatArrayArray;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.nodeproperties.InnerNodePropertiesBuilder;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class FloatArrayNodePropertiesBuilder
extends InnerNodePropertiesBuilder {
    private final HugeSparseFloatArrayArray.Builder builder;
    private final float[] defaultValue;
    private final int concurrency;

    public FloatArrayNodePropertiesBuilder(DefaultValue defaultValue, int concurrency) {
        this.concurrency = concurrency;
        this.defaultValue = defaultValue.floatArrayValue();
        this.builder = HugeSparseFloatArrayArray.builder((float[])this.defaultValue);
    }

    public void set(long neoNodeId, float[] value) {
        this.builder.set(neoNodeId, value);
    }

    @Override
    protected Class<?> valueClass() {
        return float[].class;
    }

    @Override
    public void setValue(long neoNodeId, Value value) {
        this.set(neoNodeId, Neo4jValueConversion.getFloatArray(value));
    }

    @Override
    public NodePropertyValues buildDirect(long size) {
        return new FloatArrayStoreNodePropertyValues(this.builder.build(), size);
    }

    @Override
    public FloatArrayNodePropertyValues build(long size, IdMap idMap) {
        HugeSparseFloatArrayArray propertiesByNeoIds = this.builder.build();
        HugeSparseFloatArrayArray.Builder propertiesByMappedIdsBuilder = HugeSparseFloatArrayArray.builder((float[])this.defaultValue);
        DrainingIterator drainingIterator = propertiesByNeoIds.drainingIterator();
        List tasks = IntStream.range(0, this.concurrency).mapToObj(threadId -> () -> {
            DrainingIterator.DrainingBatch batch = drainingIterator.drainingBatch();
            while (drainingIterator.next(batch)) {
                float[][] page = (float[][])batch.page;
                long offset = batch.offset;
                long end = Math.min(offset + (long)page.length, idMap.highestNeoId() + 1L) - offset;
                int pageIndex = 0;
                while ((long)pageIndex < end) {
                    float[] value;
                    long neoId = offset + (long)pageIndex;
                    long mappedId = idMap.toMappedNodeId(neoId);
                    if (mappedId != -1L && (value = page[pageIndex]) != null && !Arrays.equals(value, this.defaultValue)) {
                        propertiesByMappedIdsBuilder.set(mappedId, value);
                    }
                    ++pageIndex;
                }
            }
        }).collect(Collectors.toList());
        ParallelUtil.run(tasks, Pools.DEFAULT);
        HugeSparseFloatArrayArray propertyValues = propertiesByMappedIdsBuilder.build();
        return new FloatArrayStoreNodePropertyValues(propertyValues, size);
    }

    static class FloatArrayStoreNodePropertyValues
    implements FloatArrayNodePropertyValues {
        private final HugeSparseFloatArrayArray propertyValues;
        private final long size;

        FloatArrayStoreNodePropertyValues(HugeSparseFloatArrayArray propertyValues, long size) {
            this.propertyValues = propertyValues;
            this.size = size;
        }

        @Override
        public float[] floatArrayValue(long nodeId) {
            return this.propertyValues.get(nodeId);
        }

        @Override
        public long size() {
            return this.size;
        }
    }
}

