/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.nodeproperties;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseDoubleArray;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.nodeproperties.InnerNodePropertiesBuilder;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class DoubleNodePropertiesBuilder
extends InnerNodePropertiesBuilder {
    private volatile double maxValue;
    private static final VarHandle MAX_VALUE;
    private final HugeSparseDoubleArray.Builder builder;
    private final double defaultValue;
    private final int concurrency;

    public DoubleNodePropertiesBuilder(DefaultValue defaultValue, int concurrency) {
        this.defaultValue = defaultValue.doubleValue();
        this.concurrency = concurrency;
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.builder = HugeSparseDoubleArray.builder((double)this.defaultValue);
    }

    @Override
    protected Class<?> valueClass() {
        return Double.TYPE;
    }

    public void set(long neoNodeId, double value) {
        this.builder.set(neoNodeId, value);
        this.updateMaxValue(value);
    }

    @Override
    public void setValue(long neoNodeId, Value value) {
        double doubleValue = Neo4jValueConversion.getDoubleValue(value);
        this.set(neoNodeId, doubleValue);
    }

    @Override
    public NodePropertyValues buildDirect(long size) {
        return new DoubleStoreNodePropertyValues(this.builder.build(), size, OptionalDouble.empty());
    }

    @Override
    public DoubleNodePropertyValues build(long size, IdMap idMap) {
        HugeSparseDoubleArray propertiesByNeoIds = this.builder.build();
        HugeSparseDoubleArray.Builder propertiesByMappedIdsBuilder = HugeSparseDoubleArray.builder((double)this.defaultValue);
        DrainingIterator drainingIterator = propertiesByNeoIds.drainingIterator();
        List tasks = IntStream.range(0, this.concurrency).mapToObj(threadId -> () -> {
            DrainingIterator.DrainingBatch batch = drainingIterator.drainingBatch();
            while (drainingIterator.next(batch)) {
                double[] page = (double[])batch.page;
                long offset = batch.offset;
                long end = Math.min(offset + (long)page.length, idMap.highestNeoId() + 1L) - offset;
                int pageIndex = 0;
                while ((long)pageIndex < end) {
                    double value;
                    long neoId = offset + (long)pageIndex;
                    long mappedId = idMap.toMappedNodeId(neoId);
                    if (mappedId != -1L && Double.compare(value = page[pageIndex], this.defaultValue) != 0) {
                        propertiesByMappedIdsBuilder.set(mappedId, value);
                    }
                    ++pageIndex;
                }
            }
        }).collect(Collectors.toList());
        ParallelUtil.run(tasks, Pools.DEFAULT);
        HugeSparseDoubleArray propertyValues = propertiesByMappedIdsBuilder.build();
        OptionalDouble maybeMaxValue = size > 0L ? OptionalDouble.of(MAX_VALUE.getVolatile(this)) : OptionalDouble.empty();
        return new DoubleStoreNodePropertyValues(propertyValues, size, maybeMaxValue);
    }

    private void updateMaxValue(double value) {
        double currentMax = MAX_VALUE.getOpaque(this);
        if (currentMax >= value) {
            return;
        }
        while (currentMax < value) {
            double newMax = MAX_VALUE.compareAndExchange(this, currentMax, value);
            if (newMax == currentMax) {
                return;
            }
            currentMax = newMax;
        }
    }

    static {
        VarHandle maxValueHandle;
        try {
            maxValueHandle = MethodHandles.lookup().findVarHandle(DoubleNodePropertiesBuilder.class, "maxValue", Double.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        MAX_VALUE = maxValueHandle;
    }

    static class DoubleStoreNodePropertyValues
    implements DoubleNodePropertyValues {
        private final HugeSparseDoubleArray propertyValues;
        private final long size;
        private final OptionalDouble maxValue;

        DoubleStoreNodePropertyValues(HugeSparseDoubleArray propertyValues, long size, OptionalDouble maxValue) {
            this.propertyValues = propertyValues;
            this.size = size;
            this.maxValue = maxValue;
        }

        @Override
        public double doubleValue(long nodeId) {
            return this.propertyValues.get(nodeId);
        }

        @Override
        public OptionalDouble getMaxDoublePropertyValue() {
            return this.maxValue;
        }

        @Override
        public long size() {
            return this.size;
        }
    }
}

