/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.nodeproperties;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.DoubleArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseDoubleArrayArray;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.nodeproperties.InnerNodePropertiesBuilder;
import org.neo4j.gds.utils.Neo4jValueConversion;
import org.neo4j.values.storable.Value;

public class DoubleArrayNodePropertiesBuilder
extends InnerNodePropertiesBuilder {
    private final HugeSparseDoubleArrayArray.Builder builder;
    private final double[] defaultValue;
    private final int concurrency;

    public DoubleArrayNodePropertiesBuilder(DefaultValue defaultValue, int concurrency) {
        this.concurrency = concurrency;
        this.defaultValue = defaultValue.doubleArrayValue();
        this.builder = HugeSparseDoubleArrayArray.builder((double[])this.defaultValue);
    }

    public void set(long neoNodeId, double[] value) {
        this.builder.set(neoNodeId, value);
    }

    @Override
    protected Class<?> valueClass() {
        return double[].class;
    }

    @Override
    public void setValue(long neoNodeId, Value value) {
        this.set(neoNodeId, Neo4jValueConversion.getDoubleArray(value));
    }

    @Override
    public NodePropertyValues buildDirect(long size) {
        return new DoubleArrayStoreNodePropertyValues(this.builder.build(), size);
    }

    @Override
    public DoubleArrayNodePropertyValues build(long size, IdMap idMap) {
        HugeSparseDoubleArrayArray propertiesByNeoIds = this.builder.build();
        HugeSparseDoubleArrayArray.Builder propertiesByMappedIdsBuilder = HugeSparseDoubleArrayArray.builder((double[])this.defaultValue);
        DrainingIterator drainingIterator = propertiesByNeoIds.drainingIterator();
        List tasks = IntStream.range(0, this.concurrency).mapToObj(threadId -> () -> {
            DrainingIterator.DrainingBatch batch = drainingIterator.drainingBatch();
            while (drainingIterator.next(batch)) {
                double[][] page = (double[][])batch.page;
                long offset = batch.offset;
                long end = Math.min(offset + (long)page.length, idMap.highestNeoId() + 1L) - offset;
                int pageIndex = 0;
                while ((long)pageIndex < end) {
                    double[] value;
                    long neoId = offset + (long)pageIndex;
                    long mappedId = idMap.toMappedNodeId(neoId);
                    if (!(mappedId == -1L || (value = page[pageIndex]) == null || this.defaultValue != null && Arrays.equals(value, this.defaultValue))) {
                        propertiesByMappedIdsBuilder.set(mappedId, value);
                    }
                    ++pageIndex;
                }
            }
        }).collect(Collectors.toList());
        ParallelUtil.run(tasks, Pools.DEFAULT);
        HugeSparseDoubleArrayArray propertyValues = propertiesByMappedIdsBuilder.build();
        return new DoubleArrayStoreNodePropertyValues(propertyValues, size);
    }

    static class DoubleArrayStoreNodePropertyValues
    implements DoubleArrayNodePropertyValues {
        private final HugeSparseDoubleArrayArray propertyValues;
        private final long size;

        DoubleArrayStoreNodePropertyValues(HugeSparseDoubleArrayArray propertyValues, long size) {
            this.propertyValues = propertyValues;
            this.size = size;
        }

        @Override
        public double[] doubleArrayValue(long nodeId) {
            return this.propertyValues.get(nodeId);
        }

        @Override
        public long size() {
            return this.size;
        }
    }
}

