/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.ImmutablePropertyConfig;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;

@ParametersAreNonnullByDefault
@Generated(from="GraphFactory.relationshipsBuilder", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class RelationshipsBuilderBuilder {
    private static final long INIT_BIT_NODES = 1L;
    private long initBits = 1L;
    @Nullable
    private PartialIdMap nodes;
    private Optional<Orientation> orientation = Optional.empty();
    private List<GraphFactory.PropertyConfig> propertyConfigs = new ArrayList<GraphFactory.PropertyConfig>();
    private Optional<Aggregation> aggregation = Optional.empty();
    private Optional<Boolean> validateRelationships = Optional.empty();
    private Optional<Integer> concurrency = Optional.empty();
    private Optional<ExecutorService> executorService = Optional.empty();

    public final RelationshipsBuilderBuilder nodes(PartialIdMap nodes) {
        this.nodes = Objects.requireNonNull(nodes, "nodes");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final RelationshipsBuilderBuilder orientation(Orientation orientation) {
        this.orientation = Optional.of(orientation);
        return this;
    }

    public final RelationshipsBuilderBuilder orientation(Optional<? extends Orientation> orientation) {
        this.orientation = Objects.requireNonNull(orientation, "orientation");
        return this;
    }

    public final RelationshipsBuilderBuilder addPropertyConfig(GraphFactory.PropertyConfig element) {
        element = ImmutablePropertyConfig.copyOf(element);
        this.propertyConfigs.add(Objects.requireNonNull(element, "propertyConfigs element"));
        return this;
    }

    public final RelationshipsBuilderBuilder addPropertyConfig(Aggregation aggregation, DefaultValue defaultValue) {
        return this.addPropertyConfig(ImmutablePropertyConfig.of(aggregation, defaultValue));
    }

    public final RelationshipsBuilderBuilder addPropertyConfigs(GraphFactory.PropertyConfig ... elements) {
        for (GraphFactory.PropertyConfig element : elements) {
            element = ImmutablePropertyConfig.copyOf(element);
            this.propertyConfigs.add(Objects.requireNonNull(element, "propertyConfigs element"));
        }
        return this;
    }

    public final RelationshipsBuilderBuilder propertyConfigs(Iterable<? extends GraphFactory.PropertyConfig> elements) {
        this.propertyConfigs.clear();
        return this.addAllPropertyConfigs(elements);
    }

    public final RelationshipsBuilderBuilder addAllPropertyConfigs(Iterable<? extends GraphFactory.PropertyConfig> elements) {
        for (GraphFactory.PropertyConfig propertyConfig : elements) {
            GraphFactory.PropertyConfig propertyConfig2 = ImmutablePropertyConfig.copyOf(propertyConfig);
            this.propertyConfigs.add(Objects.requireNonNull(propertyConfig2, "propertyConfigs element"));
        }
        return this;
    }

    public final RelationshipsBuilderBuilder aggregation(Aggregation aggregation) {
        this.aggregation = Optional.of(aggregation);
        return this;
    }

    public final RelationshipsBuilderBuilder aggregation(Optional<? extends Aggregation> aggregation) {
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
        return this;
    }

    public final RelationshipsBuilderBuilder validateRelationships(boolean validateRelationships) {
        this.validateRelationships = Optional.of(validateRelationships);
        return this;
    }

    public final RelationshipsBuilderBuilder validateRelationships(Optional<Boolean> validateRelationships) {
        this.validateRelationships = Objects.requireNonNull(validateRelationships, "validateRelationships");
        return this;
    }

    public final RelationshipsBuilderBuilder concurrency(int concurrency) {
        this.concurrency = Optional.of(concurrency);
        return this;
    }

    public final RelationshipsBuilderBuilder concurrency(Optional<Integer> concurrency) {
        this.concurrency = Objects.requireNonNull(concurrency, "concurrency");
        return this;
    }

    public final RelationshipsBuilderBuilder executorService(ExecutorService executorService) {
        this.executorService = Optional.of(executorService);
        return this;
    }

    public final RelationshipsBuilderBuilder executorService(Optional<? extends ExecutorService> executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        return this;
    }

    public RelationshipsBuilder build() {
        this.checkRequiredAttributes();
        return GraphFactory.relationshipsBuilder(this.nodes, this.orientation, RelationshipsBuilderBuilder.createUnmodifiableList(true, this.propertyConfigs), this.aggregation, this.validateRelationships, this.concurrency, this.executorService);
    }

    private boolean nodesIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.nodesIsSet()) {
            attributes.add("nodes");
        }
        return "Cannot build relationshipsBuilder, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

