/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.AdjacencyListsWithProperties;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.PropertyReader;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.ThreadLocalSingleTypeRelationshipImporter;
import org.neo4j.gds.utils.AutoCloseableThreadLocal;

public class RelationshipsBuilder {
    private final PartialIdMap idMap;
    private final boolean loadRelationshipProperty;
    private final boolean isMultiGraph;
    private final Orientation orientation;
    private final SingleTypeRelationshipImporter singleTypeRelationshipImporter;
    private final int concurrency;
    private final ExecutorService executorService;
    private final AutoCloseableThreadLocal<ThreadLocalBuilder> threadLocalBuilders;

    RelationshipsBuilder(PartialIdMap idMap, Orientation orientation, int bufferSize, int[] propertyKeyIds, SingleTypeRelationshipImporter singleTypeRelationshipImporter, boolean loadRelationshipProperty, boolean isMultiGraph, int concurrency, ExecutorService executorService) {
        this.idMap = idMap;
        this.orientation = orientation;
        this.singleTypeRelationshipImporter = singleTypeRelationshipImporter;
        this.loadRelationshipProperty = loadRelationshipProperty;
        this.isMultiGraph = isMultiGraph;
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.threadLocalBuilders = AutoCloseableThreadLocal.withInitial(() -> new ThreadLocalBuilder(idMap, singleTypeRelationshipImporter, bufferSize, propertyKeyIds));
    }

    public void add(long source, long target) {
        this.addFromInternal(this.idMap.toMappedNodeId(source), this.idMap.toMappedNodeId(target));
    }

    public void add(long source, long target, double relationshipPropertyValue) {
        this.addFromInternal(this.idMap.toMappedNodeId(source), this.idMap.toMappedNodeId(target), relationshipPropertyValue);
    }

    public void add(long source, long target, double[] relationshipPropertyValues) {
        this.addFromInternal(this.idMap.toMappedNodeId(source), this.idMap.toMappedNodeId(target), relationshipPropertyValues);
    }

    public <T extends Relationship> void add(Stream<T> relationshipStream) {
        relationshipStream.forEach(this::add);
    }

    public <T extends Relationship> void add(T relationship) {
        this.add(relationship.sourceNodeId(), relationship.targetNodeId(), relationship.property());
    }

    public <T extends Relationship> void addFromInternal(Stream<T> relationshipStream) {
        relationshipStream.forEach(this::addFromInternal);
    }

    public <T extends Relationship> void addFromInternal(T relationship) {
        this.addFromInternal(relationship.sourceNodeId(), relationship.targetNodeId(), relationship.property());
    }

    public void addFromInternal(long source, long target) {
        ((ThreadLocalBuilder)this.threadLocalBuilders.get()).addRelationship(source, target);
    }

    public void addFromInternal(long source, long target, double relationshipPropertyValue) {
        ((ThreadLocalBuilder)this.threadLocalBuilders.get()).addRelationship(source, target, relationshipPropertyValue);
    }

    public void addFromInternal(long source, long target, double[] relationshipPropertyValues) {
        ((ThreadLocalBuilder)this.threadLocalBuilders.get()).addRelationship(source, target, relationshipPropertyValues);
    }

    public Relationships build() {
        return this.buildAll().get(0);
    }

    public List<Relationships> buildAll() {
        return this.buildAll(Optional.empty(), Optional.empty());
    }

    public List<Relationships> buildAll(Optional<AdjacencyCompressor.ValueMapper> mapper, Optional<LongConsumer> drainCountConsumer) {
        this.threadLocalBuilders.close();
        Collection<AdjacencyBuffer.AdjacencyListBuilderTask> adjacencyListBuilderTasks = this.singleTypeRelationshipImporter.adjacencyListBuilderTasks(mapper, drainCountConsumer);
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks(adjacencyListBuilderTasks).executor(this.executorService).run();
        AdjacencyListsWithProperties adjacencyListsWithProperties = this.singleTypeRelationshipImporter.build();
        AdjacencyList adjacencyList = adjacencyListsWithProperties.adjacency();
        long relationshipCount = adjacencyListsWithProperties.relationshipCount();
        if (this.loadRelationshipProperty) {
            return adjacencyListsWithProperties.properties().stream().map(compressedProperties -> Relationships.of(relationshipCount, this.orientation, this.isMultiGraph, adjacencyList, compressedProperties, Double.NaN)).collect(Collectors.toList());
        }
        return List.of(Relationships.of(relationshipCount, this.orientation, this.isMultiGraph, adjacencyList));
    }

    public static interface Relationship {
        public long sourceNodeId();

        public long targetNodeId();

        public double property();
    }

    private static class ThreadLocalBuilder
    implements AutoCloseable {
        private final ThreadLocalSingleTypeRelationshipImporter importer;
        private final PropertyReader.Buffered bufferedPropertyReader;
        private final int[] propertyKeyIds;
        private int localRelationshipId;

        ThreadLocalBuilder(PartialIdMap idMap, SingleTypeRelationshipImporter singleTypeRelationshipImporter, int bufferSize, int[] propertyKeyIds) {
            this.propertyKeyIds = propertyKeyIds;
            if (propertyKeyIds.length > 1) {
                this.bufferedPropertyReader = PropertyReader.buffered(bufferSize, propertyKeyIds.length);
                this.importer = singleTypeRelationshipImporter.threadLocalImporter(idMap, bufferSize, this.bufferedPropertyReader);
            } else {
                this.bufferedPropertyReader = null;
                this.importer = singleTypeRelationshipImporter.threadLocalImporter(idMap, bufferSize, PropertyReader.preLoaded());
            }
        }

        void addRelationship(long source, long target) {
            this.importer.buffer().add(source, target);
            if (this.importer.buffer().isFull()) {
                this.flushBuffer();
            }
        }

        void addRelationship(long source, long target, double relationshipPropertyValue) {
            this.importer.buffer().add(source, target, Double.doubleToLongBits(relationshipPropertyValue), Neo4jProxy.noPropertyReference());
            if (this.importer.buffer().isFull()) {
                this.flushBuffer();
            }
        }

        void addRelationship(long source, long target, double[] relationshipPropertyValues) {
            int nextRelationshipId = this.localRelationshipId++;
            this.importer.buffer().add(source, target, nextRelationshipId, Neo4jProxy.noPropertyReference());
            int[] keyIds = this.propertyKeyIds;
            for (int i = 0; i < keyIds.length; ++i) {
                this.bufferedPropertyReader.add(nextRelationshipId, keyIds[i], relationshipPropertyValues[i]);
            }
            if (this.importer.buffer().isFull()) {
                this.flushBuffer();
            }
        }

        private void flushBuffer() {
            this.importer.importRelationships();
            this.importer.buffer().reset();
            this.localRelationshipId = 0;
        }

        @Override
        public void close() {
            this.flushBuffer();
        }
    }
}

