/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.schema.ImmutableNodeSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;

@ParametersAreNonnullByDefault
@Generated(from="GraphFactory.nodesBuilder", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class NodesBuilderBuilder {
    private static final long INIT_BIT_MAX_ORIGINAL_ID = 1L;
    private long initBits = 1L;
    private long maxOriginalId;
    private Optional<Long> nodeCount = Optional.empty();
    private Optional<NodeSchema> nodeSchema = Optional.empty();
    private Optional<Boolean> hasLabelInformation = Optional.empty();
    private Optional<Boolean> hasProperties = Optional.empty();
    private Optional<Boolean> deduplicateIds = Optional.empty();
    private Optional<Integer> concurrency = Optional.empty();

    public final NodesBuilderBuilder maxOriginalId(long maxOriginalId) {
        this.maxOriginalId = maxOriginalId;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final NodesBuilderBuilder nodeCount(long nodeCount) {
        this.nodeCount = Optional.of(nodeCount);
        return this;
    }

    public final NodesBuilderBuilder nodeCount(Optional<Long> nodeCount) {
        this.nodeCount = Objects.requireNonNull(nodeCount, "nodeCount");
        return this;
    }

    public final NodesBuilderBuilder nodeSchema(NodeSchema nodeSchema) {
        this.nodeSchema = Optional.of(nodeSchema);
        return this;
    }

    public final NodesBuilderBuilder nodeSchema(Map<NodeLabel, Map<String, PropertySchema>> properties) {
        return this.nodeSchema(ImmutableNodeSchema.of(properties));
    }

    public final NodesBuilderBuilder nodeSchema(Optional<? extends NodeSchema> nodeSchema) {
        this.nodeSchema = Objects.requireNonNull(nodeSchema, "nodeSchema");
        return this;
    }

    public final NodesBuilderBuilder hasLabelInformation(boolean hasLabelInformation) {
        this.hasLabelInformation = Optional.of(hasLabelInformation);
        return this;
    }

    public final NodesBuilderBuilder hasLabelInformation(Optional<Boolean> hasLabelInformation) {
        this.hasLabelInformation = Objects.requireNonNull(hasLabelInformation, "hasLabelInformation");
        return this;
    }

    public final NodesBuilderBuilder hasProperties(boolean hasProperties) {
        this.hasProperties = Optional.of(hasProperties);
        return this;
    }

    public final NodesBuilderBuilder hasProperties(Optional<Boolean> hasProperties) {
        this.hasProperties = Objects.requireNonNull(hasProperties, "hasProperties");
        return this;
    }

    public final NodesBuilderBuilder deduplicateIds(boolean deduplicateIds) {
        this.deduplicateIds = Optional.of(deduplicateIds);
        return this;
    }

    public final NodesBuilderBuilder deduplicateIds(Optional<Boolean> deduplicateIds) {
        this.deduplicateIds = Objects.requireNonNull(deduplicateIds, "deduplicateIds");
        return this;
    }

    public final NodesBuilderBuilder concurrency(int concurrency) {
        this.concurrency = Optional.of(concurrency);
        return this;
    }

    public final NodesBuilderBuilder concurrency(Optional<Integer> concurrency) {
        this.concurrency = Objects.requireNonNull(concurrency, "concurrency");
        return this;
    }

    public NodesBuilder build() {
        this.checkRequiredAttributes();
        return GraphFactory.nodesBuilder(this.maxOriginalId, this.nodeCount, this.nodeSchema, this.hasLabelInformation, this.hasProperties, this.deduplicateIds, this.concurrency);
    }

    private boolean maxOriginalIdIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.maxOriginalIdIsSet()) {
            attributes.add("maxOriginalId");
        }
        return "Cannot build nodesBuilder, some of required attributes are not set " + attributes;
    }
}

