/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.ObjectIntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.compat.LongPropertyReference;
import org.neo4j.gds.core.loading.IdMapBuilder;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.loading.NodeImporter;
import org.neo4j.gds.core.loading.NodesBatchBuffer;
import org.neo4j.gds.core.loading.NodesBatchBufferBuilder;
import org.neo4j.gds.core.loading.construction.ImmutableIdMapAndProperties;
import org.neo4j.gds.core.loading.construction.NodeLabelToken;
import org.neo4j.gds.core.loading.construction.NodeLabelTokens;
import org.neo4j.gds.core.loading.nodeproperties.NodePropertiesFromStoreBuilder;
import org.neo4j.gds.core.utils.RawValues;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeAtomicGrowingBitSet;
import org.neo4j.gds.utils.AutoCloseableThreadLocal;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.values.storable.Value;

public final class NodesBuilder {
    public static final DefaultValue NO_PROPERTY_VALUE = DefaultValue.DEFAULT;
    public static final long UNKNOWN_MAX_ID = -1L;
    private final long maxOriginalId;
    private final int concurrency;
    private int nextLabelId;
    private final ObjectIntMap<NodeLabel> elementIdentifierLabelTokenMapping;
    private final IdMapBuilder idMapBuilder;
    private final LabelInformation.Builder labelInformationBuilder;
    private final IntObjectHashMap<List<NodeLabel>> labelTokenNodeLabelMapping;
    private final LongAdder importedNodes;
    private final AutoCloseableThreadLocal<ThreadLocalBuilder> threadLocalBuilder;
    private final NodeImporter nodeImporter;
    private final Lock lock;
    private final ConcurrentMap<String, NodePropertiesFromStoreBuilder> propertyBuildersByPropertyKey;
    private final boolean hasProperties;

    NodesBuilder(long maxOriginalId, int concurrency, ObjectIntMap<NodeLabel> elementIdentifierLabelTokenMapping, IntObjectHashMap<List<NodeLabel>> labelTokenNodeLabelMapping, ConcurrentMap<String, NodePropertiesFromStoreBuilder> propertyBuildersByPropertyKey, IdMapBuilder idMapBuilder, boolean hasLabelInformation, boolean hasProperties, boolean deduplicateIds) {
        this.maxOriginalId = maxOriginalId;
        this.concurrency = concurrency;
        this.elementIdentifierLabelTokenMapping = elementIdentifierLabelTokenMapping;
        this.idMapBuilder = idMapBuilder;
        this.labelInformationBuilder = !hasLabelInformation ? LabelInformation.single(NodeLabel.ALL_NODES) : LabelInformation.builder(maxOriginalId + 1L);
        this.labelTokenNodeLabelMapping = labelTokenNodeLabelMapping;
        this.nextLabelId = 0;
        this.lock = new ReentrantLock(true);
        this.propertyBuildersByPropertyKey = propertyBuildersByPropertyKey;
        this.hasProperties = hasProperties;
        this.importedNodes = new LongAdder();
        this.nodeImporter = new NodeImporter(idMapBuilder, this.labelInformationBuilder, (IntObjectMap<List<NodeLabel>>)labelTokenNodeLabelMapping, hasProperties);
        Function<NodeLabel, Integer> labelTokenIdFn = elementIdentifierLabelTokenMapping.isEmpty() ? this::getOrCreateLabelTokenId : this::getLabelTokenId;
        Function<String, NodePropertiesFromStoreBuilder> propertyBuilderFn = propertyBuildersByPropertyKey.isEmpty() ? this::getOrCreatePropertyBuilder : this::getPropertyBuilder;
        LongPredicate seenNodeIdPredicate = NodesBuilder.seenNodesPredicate(deduplicateIds, maxOriginalId);
        long highestPossibleNodeCount = maxOriginalId == -1L ? Long.MAX_VALUE : maxOriginalId + 1L;
        this.threadLocalBuilder = AutoCloseableThreadLocal.withInitial(() -> new ThreadLocalBuilder(this.importedNodes, this.nodeImporter, highestPossibleNodeCount, seenNodeIdPredicate, hasLabelInformation, hasProperties, labelTokenIdFn, propertyBuilderFn));
    }

    private static LongPredicate seenNodesPredicate(boolean deduplicateIds, long maxOriginalId) {
        if (deduplicateIds) {
            if (maxOriginalId == -1L) {
                HugeAtomicGrowingBitSet seenIds = HugeAtomicGrowingBitSet.create(0L);
                return seenIds::getAndSet;
            }
            HugeAtomicBitSet seenIds = HugeAtomicBitSet.create(maxOriginalId + 1L);
            return seenIds::getAndSet;
        }
        return nodeId -> false;
    }

    public void addNode(long originalId) {
        this.addNode(originalId, NodeLabelTokens.empty());
    }

    public void addNode(long originalId, NodeLabelToken nodeLabels) {
        ((ThreadLocalBuilder)this.threadLocalBuilder.get()).addNode(originalId, nodeLabels);
    }

    public void addNode(long originalId, NodeLabel ... nodeLabels) {
        this.addNode(originalId, NodeLabelTokens.ofNodeLabels(nodeLabels));
    }

    public void addNode(long originalId, NodeLabel nodeLabel) {
        this.addNode(originalId, NodeLabelTokens.ofNodeLabel(nodeLabel));
    }

    public void addNode(long originalId, Map<String, Value> properties) {
        this.addNode(originalId, properties, NodeLabelTokens.empty());
    }

    public void addNode(long originalId, Map<String, Value> properties, NodeLabelToken nodeLabels) {
        ((ThreadLocalBuilder)this.threadLocalBuilder.get()).addNode(originalId, properties, nodeLabels);
    }

    public void addNode(long originalId, Map<String, Value> properties, NodeLabel ... nodeLabels) {
        this.addNode(originalId, properties, NodeLabelTokens.ofNodeLabels(nodeLabels));
    }

    public void addNode(long originalId, Map<String, Value> properties, NodeLabel nodeLabel) {
        this.addNode(originalId, properties, NodeLabelTokens.ofNodeLabel(nodeLabel));
    }

    public long importedNodes() {
        return this.importedNodes.sum();
    }

    public IdMapAndProperties build() {
        return this.build(this.maxOriginalId);
    }

    public IdMapAndProperties build(long highestNeoId) {
        this.threadLocalBuilder.forEach(ThreadLocalBuilder::flush);
        this.threadLocalBuilder.close();
        IdMap idMap = this.idMapBuilder.build(this.labelInformationBuilder, highestNeoId, this.concurrency);
        Optional<Object> nodeProperties = Optional.empty();
        if (this.hasProperties) {
            nodeProperties = Optional.of(this.buildProperties(idMap));
        }
        return ImmutableIdMapAndProperties.of(idMap, nodeProperties);
    }

    private Map<String, NodePropertyValues> buildProperties(IdMap idMap) {
        return this.propertyBuildersByPropertyKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NodePropertiesFromStoreBuilder)e.getValue()).build(idMap)));
    }

    public void close(RuntimeException exception) {
        this.threadLocalBuilder.close();
        throw exception;
    }

    private int getOrCreateLabelTokenId(NodeLabel nodeLabel) {
        int token = this.elementIdentifierLabelTokenMapping.getOrDefault((Object)nodeLabel, -2);
        if (token == -2) {
            this.lock.lock();
            token = this.elementIdentifierLabelTokenMapping.getOrDefault((Object)nodeLabel, -2);
            if (token == -2) {
                token = this.nextLabelId++;
                this.labelTokenNodeLabelMapping.put(token, Collections.singletonList(nodeLabel));
                this.elementIdentifierLabelTokenMapping.put((Object)nodeLabel, token);
            }
            this.lock.unlock();
        }
        return token;
    }

    private int getLabelTokenId(NodeLabel nodeLabel) {
        if (!this.elementIdentifierLabelTokenMapping.containsKey((Object)nodeLabel)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No token was specified for node label %s", (Object[])new Object[]{nodeLabel}));
        }
        return this.elementIdentifierLabelTokenMapping.get((Object)nodeLabel);
    }

    private NodePropertiesFromStoreBuilder getOrCreatePropertyBuilder(String propertyKey) {
        return this.propertyBuildersByPropertyKey.computeIfAbsent(propertyKey, __ -> NodePropertiesFromStoreBuilder.of(NO_PROPERTY_VALUE, this.concurrency));
    }

    private NodePropertiesFromStoreBuilder getPropertyBuilder(String propertyKey) {
        return (NodePropertiesFromStoreBuilder)this.propertyBuildersByPropertyKey.get(propertyKey);
    }

    private static class ThreadLocalBuilder
    implements AutoCloseable {
        private static final long NOT_INITIALIZED = -42L;
        private final long[] anyLabelArray = new long[]{-42L};
        private final LongAdder importedNodes;
        private final LongPredicate seenNodeIdPredicate;
        private final NodesBatchBuffer buffer;
        private final Function<NodeLabel, Integer> labelTokenIdFn;
        private final Function<String, NodePropertiesFromStoreBuilder> propertyBuilderFn;
        private final NodeImporter nodeImporter;
        private final List<Map<String, Value>> batchNodeProperties;

        ThreadLocalBuilder(LongAdder importedNodes, NodeImporter nodeImporter, long highestPossibleNodeCount, LongPredicate seenNodeIdPredicate, boolean hasLabelInformation, boolean hasProperties, Function<NodeLabel, Integer> labelTokenIdFn, Function<String, NodePropertiesFromStoreBuilder> propertyBuilderFn) {
            this.importedNodes = importedNodes;
            this.seenNodeIdPredicate = seenNodeIdPredicate;
            this.labelTokenIdFn = labelTokenIdFn;
            this.propertyBuilderFn = propertyBuilderFn;
            this.buffer = new NodesBatchBufferBuilder().capacity(10000).highestPossibleNodeCount(highestPossibleNodeCount).hasLabelInformation(hasLabelInformation).readProperty(hasProperties).build();
            this.nodeImporter = nodeImporter;
            this.batchNodeProperties = new ArrayList<Map<String, Value>>(this.buffer.capacity());
        }

        public void addNode(long originalId, NodeLabelToken nodeLabels) {
            if (!this.seenNodeIdPredicate.test(originalId)) {
                long[] labels = this.labelTokens(nodeLabels);
                this.buffer.add(originalId, LongPropertyReference.empty(), labels);
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                    this.reset();
                }
            }
        }

        public void addNode(long originalId, Map<String, Value> properties, NodeLabelToken nodeLabels) {
            if (!this.seenNodeIdPredicate.test(originalId)) {
                long[] labels = this.labelTokens(nodeLabels);
                int propertyReference = this.batchNodeProperties.size();
                this.batchNodeProperties.add(properties);
                this.buffer.add(originalId, LongPropertyReference.of((long)propertyReference), labels);
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                    this.reset();
                }
            }
        }

        private long[] labelTokens(NodeLabelToken nodeLabels) {
            if (nodeLabels.isEmpty()) {
                return this.anyLabelArray();
            }
            long[] labelIds = new long[nodeLabels.size()];
            for (int i = 0; i < labelIds.length; ++i) {
                labelIds[i] = this.labelTokenIdFn.apply(nodeLabels.get(i)).intValue();
            }
            return labelIds;
        }

        public void flush() {
            this.flushBuffer();
            this.reset();
        }

        private void flushBuffer() {
            long importedNodesAndProperties = this.nodeImporter.importNodes(this.buffer, (nodeReference, labelIds, propertiesReference) -> {
                if (!propertiesReference.isEmpty()) {
                    int propertyValueIndex = (int)((LongPropertyReference)propertiesReference).id;
                    Map<String, Value> properties = this.batchNodeProperties.get(propertyValueIndex);
                    MutableInt importedProperties = new MutableInt(0);
                    properties.forEach((propertyKey, propertyValue) -> importedProperties.add(this.importProperty(nodeReference, (String)propertyKey, (Value)propertyValue)));
                    return importedProperties.intValue();
                }
                return 0;
            });
            int importedNodes = RawValues.getHead(importedNodesAndProperties);
            this.importedNodes.add(importedNodes);
        }

        private void reset() {
            this.buffer.reset();
            this.batchNodeProperties.clear();
        }

        @Override
        public void close() {
        }

        private int importProperty(long neoNodeId, String propertyKey, Value value) {
            int propertiesImported = 0;
            NodePropertiesFromStoreBuilder nodePropertyBuilder = this.propertyBuilderFn.apply(propertyKey);
            if (nodePropertyBuilder != null) {
                nodePropertyBuilder.set(neoNodeId, value);
                ++propertiesImported;
            }
            return propertiesImported;
        }

        private long[] anyLabelArray() {
            long[] anyLabelArray = this.anyLabelArray;
            if (anyLabelArray[0] == -42L) {
                anyLabelArray[0] = this.labelTokenIdFn.apply(NodeLabel.ALL_NODES).intValue();
            }
            return anyLabelArray;
        }
    }

    @ValueClass
    public static interface IdMapAndProperties {
        public IdMap idMap();

        public Optional<Map<String, NodePropertyValues>> nodeProperties();
    }
}

