/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.core.loading.construction.NodeLabelToken;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Label;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.TextValue;

public final class NodeLabelTokens {
    @NotNull
    public static NodeLabelToken of(@Nullable Object nodeLabels) {
        NodeLabelToken nodeLabelToken = NodeLabelTokens.ofNullable(nodeLabels);
        if (nodeLabelToken == null) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Could not represent a value of type[%s] as nodeLabels: %s", (Object[])new Object[]{nodeLabels.getClass(), nodeLabels}));
        }
        return nodeLabelToken;
    }

    @NotNull
    public static NodeLabelToken of(final SequenceValue nodeLabels) {
        return new NodeLabelToken(){

            @Override
            public boolean isEmpty() {
                return nodeLabels.isEmpty();
            }

            @Override
            public int size() {
                return nodeLabels.length();
            }

            @Override
            @NotNull
            public NodeLabel get(int index) {
                return new NodeLabel(((TextValue)nodeLabels.value(index)).stringValue());
            }

            @Override
            public String[] getStrings() {
                String[] result = new String[nodeLabels.length()];
                for (int i = 0; i < nodeLabels.length(); ++i) {
                    result[i] = ((TextValue)nodeLabels.value(i)).stringValue();
                }
                return result;
            }
        };
    }

    @Contract(value="null -> !null")
    @Nullable
    public static NodeLabelToken ofNullable(@Nullable Object nodeLabels) {
        if (nodeLabels == null) {
            return NodeLabelTokens.empty();
        }
        if (nodeLabels instanceof NodeLabel[]) {
            return NodeLabelTokens.ofNodeLabels((NodeLabel[])nodeLabels);
        }
        if (nodeLabels instanceof String[]) {
            return new Array<String>((String[])nodeLabels, NodeLabelTokens::labelOf);
        }
        if (nodeLabels instanceof Label[]) {
            return new Array<Label>((Label[])nodeLabels, NodeLabelTokens::labelOf);
        }
        if (nodeLabels instanceof List) {
            List labels = (List)nodeLabels;
            return NodeLabelTokens.ofList(labels);
        }
        return NodeLabelTokens.ofSingleton(nodeLabels);
    }

    @NotNull
    public static NodeLabelToken empty() {
        return Null.INSTANCE;
    }

    @NotNull
    public static NodeLabelToken ofNodeLabels(NodeLabel ... nodeLabels) {
        return new Array<NodeLabel>(nodeLabels, Function.identity());
    }

    @NotNull
    public static NodeLabelToken ofStrings(String ... nodeLabelStrings) {
        return new Array<String>(nodeLabelStrings, NodeLabelTokens::labelOf);
    }

    @NotNull
    static NodeLabelToken ofNodeLabel(NodeLabel nodeLabel) {
        return new Singleton<NodeLabel>(nodeLabel, Function.identity());
    }

    @Nullable
    private static NodeLabelToken ofList(List<?> nodeLabels) {
        if (nodeLabels.isEmpty()) {
            return NodeLabelTokens.empty();
        }
        Object label = nodeLabels.get(0);
        if (nodeLabels.size() == 1) {
            return NodeLabelTokens.ofSingleton(label);
        }
        if (label instanceof NodeLabel) {
            return new JavaList(nodeLabels, Function.identity());
        }
        if (label instanceof String) {
            return new JavaList<String>(nodeLabels, NodeLabelTokens::labelOf);
        }
        if (label instanceof Label) {
            return new JavaList<Label>(nodeLabels, NodeLabelTokens::labelOf);
        }
        return null;
    }

    @Nullable
    private static NodeLabelToken ofSingleton(Object nodeLabel) {
        if (nodeLabel instanceof NodeLabel) {
            return new Singleton<NodeLabel>((NodeLabel)nodeLabel, Function.identity());
        }
        if (nodeLabel instanceof String) {
            return new Singleton<String>((String)nodeLabel, NodeLabelTokens::labelOf);
        }
        if (nodeLabel instanceof Label) {
            return new Singleton<Label>((Label)nodeLabel, NodeLabelTokens::labelOf);
        }
        return null;
    }

    private static NodeLabel labelOf(String label) {
        return new NodeLabel(label);
    }

    private static NodeLabel labelOf(Label label) {
        return new NodeLabel(label.name());
    }

    private NodeLabelTokens() {
    }

    private static final class Singleton<T>
    implements NodeLabelToken {
        private final NodeLabel item;

        private Singleton(T item, Function<T, NodeLabel> toNodeLabel) {
            this.item = toNodeLabel.apply(item);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        @NotNull
        public NodeLabel get(int index) {
            assert (index == 0);
            return this.item;
        }

        @Override
        public String[] getStrings() {
            return new String[]{this.item.name};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Singleton singleton = (Singleton)o;
            return this.item.equals((Object)singleton.item);
        }

        public int hashCode() {
            return Objects.hash(this.item);
        }
    }

    private static final class JavaList<T>
    implements NodeLabelToken {
        @NotNull
        private final List<T> nodeLabels;
        private final Function<T, NodeLabel> toNodeLabel;

        private JavaList(@NotNull List<T> nodeLabels, Function<T, NodeLabel> toNodeLabel) {
            this.nodeLabels = nodeLabels;
            this.toNodeLabel = toNodeLabel;
        }

        @Override
        public boolean isEmpty() {
            return this.nodeLabels.isEmpty();
        }

        @Override
        public int size() {
            return this.nodeLabels.size();
        }

        @Override
        @NotNull
        public NodeLabel get(int index) {
            return this.toNodeLabel.apply(this.nodeLabels.get(index));
        }

        @Override
        public String[] getStrings() {
            return (String[])this.nodeLabels.stream().map(this.toNodeLabel).map(ElementIdentifier::name).toArray(String[]::new);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaList javaList = (JavaList)o;
            return this.nodeLabels.equals(javaList.nodeLabels);
        }

        public int hashCode() {
            return Objects.hash(this.nodeLabels);
        }
    }

    private static final class Array<T>
    implements NodeLabelToken {
        @NotNull
        private final T[] nodeLabels;
        private final Function<T, NodeLabel> toNodeLabel;

        private Array(T[] nodeLabels, Function<T, NodeLabel> toNodeLabel) {
            this.nodeLabels = nodeLabels;
            this.toNodeLabel = toNodeLabel;
        }

        @Override
        public boolean isEmpty() {
            return this.nodeLabels.length == 0;
        }

        @Override
        public int size() {
            return this.nodeLabels.length;
        }

        @Override
        @NotNull
        public NodeLabel get(int index) {
            return this.toNodeLabel.apply(this.nodeLabels[index]);
        }

        @Override
        public String[] getStrings() {
            return (String[])Arrays.stream(this.nodeLabels).map(this.toNodeLabel).map(ElementIdentifier::name).toArray(String[]::new);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Array array = (Array)o;
            return Arrays.equals(this.nodeLabels, array.nodeLabels);
        }

        public int hashCode() {
            return Arrays.hashCode(this.nodeLabels);
        }
    }

    private static enum Null implements NodeLabelToken
    {
        INSTANCE;


        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        @NotNull
        public NodeLabel get(int index) {
            throw new NoSuchElementException();
        }

        @Override
        public String[] getStrings() {
            return new String[0];
        }
    }
}

