/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.construction.GraphFactory;

@ParametersAreNonnullByDefault
@Generated(from="GraphFactory.PropertyConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutablePropertyConfig
implements GraphFactory.PropertyConfig {
    private final Aggregation aggregation;
    private final DefaultValue defaultValue;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePropertyConfig(Aggregation aggregation, DefaultValue defaultValue) {
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
        this.initShim = null;
    }

    private ImmutablePropertyConfig(Builder builder) {
        if (builder.aggregation != null) {
            this.initShim.aggregation(builder.aggregation);
        }
        if (builder.defaultValue != null) {
            this.initShim.defaultValue(builder.defaultValue);
        }
        this.aggregation = this.initShim.aggregation();
        this.defaultValue = this.initShim.defaultValue();
        this.initShim = null;
    }

    private ImmutablePropertyConfig(ImmutablePropertyConfig original, Aggregation aggregation, DefaultValue defaultValue) {
        this.aggregation = aggregation;
        this.defaultValue = defaultValue;
        this.initShim = null;
    }

    private Aggregation aggregationInitialize() {
        return GraphFactory.PropertyConfig.super.aggregation();
    }

    private DefaultValue defaultValueInitialize() {
        return GraphFactory.PropertyConfig.super.defaultValue();
    }

    @Override
    public Aggregation aggregation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aggregation() : this.aggregation;
    }

    @Override
    public DefaultValue defaultValue() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultValue() : this.defaultValue;
    }

    public final ImmutablePropertyConfig withAggregation(Aggregation value) {
        if (this.aggregation == value) {
            return this;
        }
        Aggregation newValue = Objects.requireNonNull(value, "aggregation");
        if (this.aggregation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePropertyConfig(this, newValue, this.defaultValue);
    }

    public final ImmutablePropertyConfig withDefaultValue(DefaultValue value) {
        if (this.defaultValue == value) {
            return this;
        }
        DefaultValue newValue = Objects.requireNonNull(value, "defaultValue");
        return new ImmutablePropertyConfig(this, this.aggregation, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePropertyConfig && this.equalTo((ImmutablePropertyConfig)another);
    }

    private boolean equalTo(ImmutablePropertyConfig another) {
        return this.aggregation.equals((Object)another.aggregation) && this.defaultValue.equals((Object)another.defaultValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.aggregation.hashCode();
        h += (h << 5) + this.defaultValue.hashCode();
        return h;
    }

    public String toString() {
        return "PropertyConfig{aggregation=" + this.aggregation + ", defaultValue=" + this.defaultValue + "}";
    }

    public static GraphFactory.PropertyConfig of(Aggregation aggregation, DefaultValue defaultValue) {
        return new ImmutablePropertyConfig(aggregation, defaultValue);
    }

    public static GraphFactory.PropertyConfig copyOf(GraphFactory.PropertyConfig instance) {
        if (instance instanceof ImmutablePropertyConfig) {
            return (ImmutablePropertyConfig)instance;
        }
        return ImmutablePropertyConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphFactory.PropertyConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Aggregation aggregation;
        @Nullable
        private DefaultValue defaultValue;

        private Builder() {
        }

        public final Builder from(GraphFactory.PropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.aggregation(instance.aggregation());
            this.defaultValue(instance.defaultValue());
            return this;
        }

        public final Builder aggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
            return this;
        }

        public final Builder defaultValue(DefaultValue defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            return this;
        }

        public Builder clear() {
            this.aggregation = null;
            this.defaultValue = null;
            return this;
        }

        public GraphFactory.PropertyConfig build() {
            return new ImmutablePropertyConfig(this);
        }
    }

    @Generated(from="GraphFactory.PropertyConfig", generator="Immutables")
    private final class InitShim {
        private byte aggregationBuildStage = 0;
        private Aggregation aggregation;
        private byte defaultValueBuildStage = 0;
        private DefaultValue defaultValue;

        private InitShim() {
        }

        Aggregation aggregation() {
            if (this.aggregationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aggregationBuildStage == 0) {
                this.aggregationBuildStage = (byte)-1;
                this.aggregation = Objects.requireNonNull(ImmutablePropertyConfig.this.aggregationInitialize(), "aggregation");
                this.aggregationBuildStage = 1;
            }
            return this.aggregation;
        }

        void aggregation(Aggregation aggregation) {
            this.aggregation = aggregation;
            this.aggregationBuildStage = 1;
        }

        DefaultValue defaultValue() {
            if (this.defaultValueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultValueBuildStage == 0) {
                this.defaultValueBuildStage = (byte)-1;
                this.defaultValue = Objects.requireNonNull(ImmutablePropertyConfig.this.defaultValueInitialize(), "defaultValue");
                this.defaultValueBuildStage = 1;
            }
            return this.defaultValue;
        }

        void defaultValue(DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            this.defaultValueBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.aggregationBuildStage == -1) {
                attributes.add("aggregation");
            }
            if (this.defaultValueBuildStage == -1) {
                attributes.add("defaultValue");
            }
            return "Cannot build PropertyConfig, attribute initializers form cycle " + attributes;
        }
    }
}

