/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.loading.construction.NodesBuilder;

@ParametersAreNonnullByDefault
@Generated(from="NodesBuilder.IdMapAndProperties", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableIdMapAndProperties
implements NodesBuilder.IdMapAndProperties {
    private final IdMap idMap;
    @Nullable
    private final Map<String, NodePropertyValues> nodeProperties;

    private ImmutableIdMapAndProperties(IdMap idMap, Optional<? extends Map<String, NodePropertyValues>> nodeProperties) {
        this.idMap = Objects.requireNonNull(idMap, "idMap");
        this.nodeProperties = nodeProperties.orElse(null);
    }

    private ImmutableIdMapAndProperties(IdMap idMap, @Nullable Map<String, NodePropertyValues> nodeProperties) {
        this.idMap = Objects.requireNonNull(idMap, "idMap");
        this.nodeProperties = nodeProperties;
    }

    private ImmutableIdMapAndProperties(ImmutableIdMapAndProperties original, IdMap idMap, @Nullable Map<String, NodePropertyValues> nodeProperties) {
        this.idMap = idMap;
        this.nodeProperties = nodeProperties;
    }

    @Override
    public IdMap idMap() {
        return this.idMap;
    }

    @Override
    public Optional<Map<String, NodePropertyValues>> nodeProperties() {
        return Optional.ofNullable(this.nodeProperties);
    }

    public final ImmutableIdMapAndProperties withIdMap(IdMap value) {
        if (this.idMap == value) {
            return this;
        }
        IdMap newValue = Objects.requireNonNull(value, "idMap");
        return new ImmutableIdMapAndProperties(this, newValue, this.nodeProperties);
    }

    public final ImmutableIdMapAndProperties withNodeProperties(@Nullable Map<String, NodePropertyValues> value) {
        Map<String, NodePropertyValues> newValue = value;
        if (this.nodeProperties == newValue) {
            return this;
        }
        return new ImmutableIdMapAndProperties(this, this.idMap, newValue);
    }

    public final ImmutableIdMapAndProperties withNodeProperties(Optional<? extends Map<String, NodePropertyValues>> optional) {
        Map value = optional.orElse(null);
        if (this.nodeProperties == value) {
            return this;
        }
        return new ImmutableIdMapAndProperties(this, this.idMap, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdMapAndProperties && this.equalTo((ImmutableIdMapAndProperties)another);
    }

    private boolean equalTo(ImmutableIdMapAndProperties another) {
        return this.idMap.equals(another.idMap) && Objects.equals(this.nodeProperties, another.nodeProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.idMap.hashCode();
        h += (h << 5) + Objects.hashCode(this.nodeProperties);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IdMapAndProperties{");
        builder.append("idMap=").append(this.idMap);
        if (this.nodeProperties != null) {
            builder.append(", ");
            builder.append("nodeProperties=").append(this.nodeProperties);
        }
        return builder.append("}").toString();
    }

    public static NodesBuilder.IdMapAndProperties of(IdMap idMap, Optional<? extends Map<String, NodePropertyValues>> nodeProperties) {
        return new ImmutableIdMapAndProperties(idMap, nodeProperties);
    }

    public static NodesBuilder.IdMapAndProperties of(IdMap idMap, @Nullable Map<String, NodePropertyValues> nodeProperties) {
        return new ImmutableIdMapAndProperties(idMap, nodeProperties);
    }

    public static NodesBuilder.IdMapAndProperties copyOf(NodesBuilder.IdMapAndProperties instance) {
        if (instance instanceof ImmutableIdMapAndProperties) {
            return (ImmutableIdMapAndProperties)instance;
        }
        return ImmutableIdMapAndProperties.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NodesBuilder.IdMapAndProperties", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID_MAP = 1L;
        private long initBits = 1L;
        @Nullable
        private IdMap idMap;
        @Nullable
        private Map<String, NodePropertyValues> nodeProperties;

        private Builder() {
        }

        public final Builder from(NodesBuilder.IdMapAndProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.idMap(instance.idMap());
            Optional<Map<String, NodePropertyValues>> nodePropertiesOptional = instance.nodeProperties();
            if (nodePropertiesOptional.isPresent()) {
                this.nodeProperties(nodePropertiesOptional);
            }
            return this;
        }

        public final Builder idMap(IdMap idMap) {
            this.idMap = Objects.requireNonNull(idMap, "idMap");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder nodeProperties(@Nullable Map<String, NodePropertyValues> nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final Builder nodeProperties(Optional<? extends Map<String, NodePropertyValues>> nodeProperties) {
            this.nodeProperties = nodeProperties.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.idMap = null;
            this.nodeProperties = null;
            return this;
        }

        public NodesBuilder.IdMapAndProperties build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIdMapAndProperties(null, this.idMap, this.nodeProperties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("idMap");
            }
            return "Cannot build IdMapAndProperties, some of required attributes are not set " + attributes;
        }
    }
}

