/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading.construction;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.ObjectIntMap;
import com.carrotsearch.hppc.ObjectIntScatterMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.neo4j.gds.AbstractRelationshipProjection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.IdMapBehavior;
import org.neo4j.gds.core.IdMapBehaviorServiceProvider;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.IdMapBuilder;
import org.neo4j.gds.core.loading.ImmutableImportMetaData;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporterBuilder;
import org.neo4j.gds.core.loading.construction.ImmutablePropertyConfig;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.NodesBuilderBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilderBuilder;
import org.neo4j.gds.core.loading.nodeproperties.NodePropertiesFromStoreBuilder;

@Value.Style(builderVisibility=Value.Style.BuilderVisibility.PUBLIC, depluralize=true, deepImmutablesDetection=true)
public final class GraphFactory {
    private static final String DUMMY_PROPERTY = "property";

    private GraphFactory() {
    }

    public static NodesBuilderBuilder initNodesBuilder() {
        return new NodesBuilderBuilder();
    }

    public static NodesBuilderBuilder initNodesBuilder(NodeSchema nodeSchema) {
        return new NodesBuilderBuilder().nodeSchema(nodeSchema);
    }

    @Builder.Factory
    static NodesBuilder nodesBuilder(long maxOriginalId, Optional<Long> nodeCount, Optional<NodeSchema> nodeSchema, Optional<Boolean> hasLabelInformation, Optional<Boolean> hasProperties, Optional<Boolean> deduplicateIds, Optional<Integer> concurrency) {
        boolean labelInformation = nodeSchema.map(schema -> !schema.availableLabels().isEmpty() || !schema.containsOnlyAllNodesLabel()).or(() -> hasLabelInformation).orElse(false);
        int threadCount = concurrency.orElse(1);
        IdMapBehavior idMapBehavior = IdMapBehaviorServiceProvider.idMapBehavior();
        Optional<Long> maybeMaxOriginalId = maxOriginalId != -1L ? Optional.of(maxOriginalId) : Optional.empty();
        IdMapBuilder idMapBuilder = idMapBehavior.create(threadCount, maybeMaxOriginalId, nodeCount);
        boolean deduplicate = deduplicateIds.orElse(true);
        return nodeSchema.map(schema -> GraphFactory.fromSchema(maxOriginalId, idMapBuilder, threadCount, schema, labelInformation, deduplicate)).orElseGet(() -> new NodesBuilder(maxOriginalId, threadCount, (ObjectIntMap<NodeLabel>)new ObjectIntScatterMap(), (IntObjectHashMap<List<NodeLabel>>)new IntObjectHashMap(), new ConcurrentHashMap<String, NodePropertiesFromStoreBuilder>(), idMapBuilder, labelInformation, hasProperties.orElse(false), deduplicate));
    }

    private static NodesBuilder fromSchema(long maxOriginalId, IdMapBuilder idMapBuilder, int concurrency, NodeSchema nodeSchema, boolean hasLabelInformation, boolean deduplicateIds) {
        Set nodeLabels = nodeSchema.availableLabels();
        ObjectIntScatterMap elementIdentifierLabelTokenMapping = new ObjectIntScatterMap();
        IntObjectHashMap labelTokenNodeLabelMapping = new IntObjectHashMap();
        MutableInt labelTokenCounter = new MutableInt(0);
        nodeLabels.forEach(nodeLabel -> {
            int labelToken = nodeLabel == NodeLabel.ALL_NODES ? -1 : labelTokenCounter.getAndIncrement();
            elementIdentifierLabelTokenMapping.put(nodeLabel, labelToken);
            labelTokenNodeLabelMapping.put(labelToken, List.of(nodeLabel));
        });
        Map<String, NodePropertiesFromStoreBuilder> propertyBuildersByPropertyKey = nodeSchema.unionProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> NodePropertiesFromStoreBuilder.of(((PropertySchema)e.getValue()).defaultValue(), concurrency)));
        return new NodesBuilder(maxOriginalId, concurrency, (ObjectIntMap<NodeLabel>)elementIdentifierLabelTokenMapping, (IntObjectHashMap<List<NodeLabel>>)labelTokenNodeLabelMapping, new ConcurrentHashMap<String, NodePropertiesFromStoreBuilder>(propertyBuildersByPropertyKey), idMapBuilder, hasLabelInformation, nodeSchema.hasProperties(), deduplicateIds);
    }

    public static RelationshipsBuilderBuilder initRelationshipsBuilder() {
        return new RelationshipsBuilderBuilder();
    }

    @Builder.Factory
    static RelationshipsBuilder relationshipsBuilder(PartialIdMap nodes, Optional<Orientation> orientation, List<PropertyConfig> propertyConfigs, Optional<Aggregation> aggregation, Optional<Boolean> validateRelationships, Optional<Integer> concurrency, Optional<ExecutorService> executorService) {
        long rootNodeCount;
        Aggregation[] aggregationArray;
        boolean loadRelationshipProperties;
        boolean bl = loadRelationshipProperties = !propertyConfigs.isEmpty();
        if (propertyConfigs.isEmpty()) {
            Aggregation[] aggregationArray2 = new Aggregation[1];
            aggregationArray = aggregationArray2;
            aggregationArray2[0] = aggregation.orElse(Aggregation.NONE);
        } else {
            aggregationArray = (Aggregation[])propertyConfigs.stream().map(PropertyConfig::aggregation).map(Aggregation::resolve).toArray(Aggregation[]::new);
        }
        Aggregation[] aggregations = aggregationArray;
        RelationshipType relationshipType = RelationshipType.ALL_RELATIONSHIPS;
        boolean isMultiGraph = Arrays.stream(aggregations).allMatch(Aggregation::equivalentToNone);
        AbstractRelationshipProjection.Builder projectionBuilder = RelationshipProjection.builder().type(relationshipType.name()).orientation(orientation.orElse(Orientation.NATURAL));
        propertyConfigs.forEach(propertyConfig -> projectionBuilder.addProperty(DUMMY_PROPERTY, DUMMY_PROPERTY, DefaultValue.of((Object)propertyConfig.defaultValue()), propertyConfig.aggregation()));
        RelationshipProjection projection = projectionBuilder.build();
        int[] propertyKeyIds = IntStream.range(0, propertyConfigs.size()).toArray();
        double[] defaultValues = propertyConfigs.stream().mapToDouble(c -> c.defaultValue().doubleValue()).toArray();
        int finalConcurrency = concurrency.orElse(1);
        OptionalLong maybeRootNodeCount = nodes.rootNodeCount();
        ImportSizing importSizing = maybeRootNodeCount.isPresent() ? ImportSizing.of(finalConcurrency, maybeRootNodeCount.getAsLong()) : ImportSizing.of(finalConcurrency);
        int bufferSize = 100000;
        if (maybeRootNodeCount.isPresent() && (rootNodeCount = maybeRootNodeCount.getAsLong()) > 0L && rootNodeCount < 100000L) {
            bufferSize = (int)rootNodeCount;
        }
        SingleTypeRelationshipImporter.ImportMetaData importMetaData = ImmutableImportMetaData.builder().projection(projection).aggregations(aggregations).propertyKeyIds(propertyKeyIds).defaultValues(defaultValues).typeTokenId(-1).build();
        SingleTypeRelationshipImporter importerFactory = new SingleTypeRelationshipImporterBuilder().importMetaData(importMetaData).nodeCountSupplier(() -> nodes.rootNodeCount().orElse(0L)).importSizing(importSizing).validateRelationships(validateRelationships.orElse(false)).build();
        return new RelationshipsBuilder(nodes, orientation.orElse(Orientation.NATURAL), bufferSize, propertyKeyIds, importerFactory, loadRelationshipProperties, isMultiGraph, finalConcurrency, executorService.orElse(Pools.DEFAULT));
    }

    public static Relationships emptyRelationships(IdMap idMap) {
        return GraphFactory.initRelationshipsBuilder().nodes(idMap).build().build();
    }

    public static HugeGraph create(IdMap idMap, Relationships relationships) {
        NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder();
        idMap.availableNodeLabels().forEach(arg_0 -> ((NodeSchema.Builder)nodeSchemaBuilder).addLabel(arg_0));
        NodeSchema nodeSchema = nodeSchemaBuilder.build();
        Orientation orientation = relationships.topology().orientation();
        RelationshipSchema.Builder relationshipSchemaBuilder = RelationshipSchema.builder();
        if (relationships.properties().isPresent()) {
            relationshipSchemaBuilder.addProperty(RelationshipType.of((String)"REL"), orientation, DUMMY_PROPERTY, ValueType.DOUBLE);
        } else {
            relationshipSchemaBuilder.addRelationshipType(RelationshipType.of((String)"REL"), orientation);
        }
        RelationshipSchema relationshipSchema = relationshipSchemaBuilder.build();
        return GraphFactory.create(GraphSchema.of((NodeSchema)nodeSchema, (RelationshipSchema)relationshipSchema, Map.of()), idMap, Map.of(), relationships);
    }

    public static HugeGraph create(GraphSchema graphSchema, IdMap idMap, Map<String, NodePropertyValues> nodeProperties, Relationships relationships) {
        return HugeGraph.create(idMap, graphSchema, nodeProperties, relationships.topology(), relationships.properties());
    }

    @ValueClass
    public static interface PropertyConfig {
        @Value.Default
        default public Aggregation aggregation() {
            return Aggregation.NONE;
        }

        @Value.Default
        default public DefaultValue defaultValue() {
            return DefaultValue.forDouble();
        }

        public static PropertyConfig withDefaults() {
            return PropertyConfig.of(Optional.empty(), Optional.empty());
        }

        public static PropertyConfig of(Aggregation aggregation, DefaultValue defaultValue) {
            return ImmutablePropertyConfig.of(aggregation, defaultValue);
        }

        public static PropertyConfig of(Optional<Aggregation> aggregation, Optional<DefaultValue> defaultValue) {
            return PropertyConfig.of(aggregation.orElse(Aggregation.NONE), defaultValue.orElse(DefaultValue.forDouble()));
        }
    }
}

