/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.core.compress.AdjacencyCompressor;

public final class ZigZagLongDecoding {
    public static int zigZagUncompress(byte[] array, int limit, long[] out) {
        return ZigZagLongDecoding.zigZagUncompress(array, 0, limit, out, Identity.INSTANCE);
    }

    public static int zigZagUncompress(byte[] array, int limit, long[] out, AdjacencyCompressor.ValueMapper mapper) {
        return ZigZagLongDecoding.zigZagUncompress(array, 0, limit, out, mapper);
    }

    static int zigZagUncompress(byte[] array, int offset, int length, long[] out, AdjacencyCompressor.ValueMapper mapper) {
        long startValue = 0L;
        long value = 0L;
        int into = 0;
        int shift = 0;
        int limit = offset + length;
        while (offset < limit) {
            long input = array[offset++];
            value += (input & 0x7FL) << shift;
            if ((input & 0x80L) == 128L) {
                out[into++] = mapper.map(startValue += value >>> 1 ^ -(value & 1L));
                value = 0L;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        return into;
    }

    private ZigZagLongDecoding() {
        throw new UnsupportedOperationException("No instances");
    }

    public static enum Identity implements AdjacencyCompressor.ValueMapper
    {
        INSTANCE{

            @Override
            public long map(long value) {
                return value;
            }
        };

    }
}

