/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

public final class VarLongEncoding {
    public static final long THRESHOLD_1_BYTE = 128L;
    public static final long THRESHOLD_2_BYTE = 16384L;
    public static final long THRESHOLD_3_BYTE = 0x200000L;
    public static final long THRESHOLD_4_BYTE = 0x10000000L;
    public static final long THRESHOLD_5_BYTE = 0x800000000L;
    public static final long THRESHOLD_6_BYTE = 0x40000000000L;
    public static final long THRESHOLD_7_BYTE = 0x2000000000000L;
    public static final long THRESHOLD_8_BYTE = 0x100000000000000L;

    public static int encodeVLongs(long[] values, int limit, byte[] out, int into) {
        return VarLongEncoding.encodeVLongs(values, 0, limit, out, into);
    }

    public static int encodedVLongsSize(long[] values, int limit) {
        return VarLongEncoding.encodedVLongsSize(values, 0, limit);
    }

    public static int encodedVLongsSize(long[] values, int offset, int limit) {
        int size = 0;
        int end = offset + limit;
        for (int i = offset; i < end; ++i) {
            if (values[i] == Long.MIN_VALUE) continue;
            size += VarLongEncoding.encodedVLongSize(values[i]);
        }
        return size;
    }

    static int encodeVLongs(long[] values, int offset, int end, byte[] out, int into) {
        for (int i = offset; i < end; ++i) {
            if (values[i] == Long.MIN_VALUE) continue;
            into = VarLongEncoding.encodeVLong(out, values[i], into);
        }
        return into;
    }

    private static int encodeVLong(byte[] buffer, long val, int output) {
        if (val < 128L) {
            buffer[output] = (byte)(val | 0x80L);
            return 1 + output;
        }
        if (val < 16384L) {
            buffer[output] = (byte)(val & 0x7FL);
            buffer[1 + output] = (byte)(val >> 7 | 0x80L);
            return 2 + output;
        }
        if (val < 0x200000L) {
            buffer[output] = (byte)(val & 0x7FL);
            buffer[1 + output] = (byte)(val >> 7 & 0x7FL);
            buffer[2 + output] = (byte)(val >> 14 | 0x80L);
            return 3 + output;
        }
        if (val < 0x10000000L) {
            buffer[output] = (byte)(val & 0x7FL);
            buffer[1 + output] = (byte)(val >> 7 & 0x7FL);
            buffer[2 + output] = (byte)(val >> 14 & 0x7FL);
            buffer[3 + output] = (byte)(val >> 21 | 0x80L);
            return 4 + output;
        }
        if (val < 0x800000000L) {
            buffer[output] = (byte)(val & 0x7FL);
            buffer[1 + output] = (byte)(val >> 7 & 0x7FL);
            buffer[2 + output] = (byte)(val >> 14 & 0x7FL);
            buffer[3 + output] = (byte)(val >> 21 & 0x7FL);
            buffer[4 + output] = (byte)(val >> 28 | 0x80L);
            return 5 + output;
        }
        if (val < 0x40000000000L) {
            buffer[output] = (byte)(val & 0x7FL);
            buffer[1 + output] = (byte)(val >> 7 & 0x7FL);
            buffer[2 + output] = (byte)(val >> 14 & 0x7FL);
            buffer[3 + output] = (byte)(val >> 21 & 0x7FL);
            buffer[4 + output] = (byte)(val >> 28 & 0x7FL);
            buffer[5 + output] = (byte)(val >> 35 | 0x80L);
            return 6 + output;
        }
        if (val < 0x2000000000000L) {
            buffer[output] = (byte)(val & 0x7FL);
            buffer[1 + output] = (byte)(val >> 7 & 0x7FL);
            buffer[2 + output] = (byte)(val >> 14 & 0x7FL);
            buffer[3 + output] = (byte)(val >> 21 & 0x7FL);
            buffer[4 + output] = (byte)(val >> 28 & 0x7FL);
            buffer[5 + output] = (byte)(val >> 35 & 0x7FL);
            buffer[6 + output] = (byte)(val >> 42 | 0x80L);
            return 7 + output;
        }
        if (val < 0x100000000000000L) {
            buffer[output] = (byte)(val & 0x7FL);
            buffer[1 + output] = (byte)(val >> 7 & 0x7FL);
            buffer[2 + output] = (byte)(val >> 14 & 0x7FL);
            buffer[3 + output] = (byte)(val >> 21 & 0x7FL);
            buffer[4 + output] = (byte)(val >> 28 & 0x7FL);
            buffer[5 + output] = (byte)(val >> 35 & 0x7FL);
            buffer[6 + output] = (byte)(val >> 42 & 0x7FL);
            buffer[7 + output] = (byte)(val >> 49 | 0x80L);
            return 8 + output;
        }
        buffer[output] = (byte)(val & 0x7FL);
        buffer[1 + output] = (byte)(val >> 7 & 0x7FL);
        buffer[2 + output] = (byte)(val >> 14 & 0x7FL);
        buffer[3 + output] = (byte)(val >> 21 & 0x7FL);
        buffer[4 + output] = (byte)(val >> 28 & 0x7FL);
        buffer[5 + output] = (byte)(val >> 35 & 0x7FL);
        buffer[6 + output] = (byte)(val >> 42 & 0x7FL);
        buffer[7 + output] = (byte)(val >> 49 & 0x7FL);
        buffer[8 + output] = (byte)(val >> 56 | 0x80L);
        return 9 + output;
    }

    public static int encodedVLongSize(long val) {
        if (val < 128L) {
            return 1;
        }
        if (val < 16384L) {
            return 2;
        }
        if (val < 0x200000L) {
            return 3;
        }
        if (val < 0x10000000L) {
            return 4;
        }
        if (val < 0x800000000L) {
            return 5;
        }
        if (val < 0x40000000000L) {
            return 6;
        }
        if (val < 0x2000000000000L) {
            return 7;
        }
        if (val < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static long zigZag(long value) {
        return value >> 63 ^ value << 1;
    }

    private VarLongEncoding() {
        throw new UnsupportedOperationException("No instances");
    }
}

