/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;

public final class ValueConverter {
    public static ValueType valueType(Value value) {
        if (value instanceof IntegralValue) {
            return ValueType.LONG;
        }
        if (value instanceof FloatingPointValue) {
            return ValueType.DOUBLE;
        }
        if (value instanceof LongArray) {
            return ValueType.LONG_ARRAY;
        }
        if (value instanceof DoubleArray) {
            return ValueType.DOUBLE_ARRAY;
        }
        if (value instanceof FloatArray) {
            return ValueType.FLOAT_ARRAY;
        }
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Loading of values of type %s is currently not supported", (Object[])new Object[]{value.getTypeName()}));
    }

    public static Value toValue(@NotNull Object valueObject) {
        return ValueConverter.toValue(ValueUtils.of((Object)valueObject));
    }

    public static Value toValue(@NotNull AnyValue value) {
        if (value.isSequenceValue()) {
            return ValueConverter.castToNumericArrayOrFail(value);
        }
        if (value instanceof Value) {
            Value storableValue = (Value)value;
            if (storableValue.valueGroup() != ValueGroup.NUMBER) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported GDS node property of type `%s`.", (Object[])new Object[]{storableValue.getTypeName()}));
            }
            return storableValue;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported GDS node property of type `%s`.", (Object[])new Object[]{value.getTypeName()}));
    }

    private static ArrayValue castToNumericArrayOrFail(AnyValue value) {
        if (value instanceof ListValue) {
            return ValueConverter.castToNumericArrayOrFail((ListValue)value);
        }
        if (value instanceof ArrayValue) {
            return ValueConverter.assertNumberArray((ArrayValue)value);
        }
        throw ValueConverter.failOnBadList(value);
    }

    private static ArrayValue assertNumberArray(ArrayValue array) {
        if (array.valueGroup() != ValueGroup.NUMBER_ARRAY) {
            throw ValueConverter.failOnBadList((AnyValue)array);
        }
        return array;
    }

    @NotNull
    private static ArrayValue castToNumericArrayOrFail(ListValue listValue) {
        if (listValue.isEmpty()) {
            return Values.EMPTY_LONG_ARRAY;
        }
        AnyValue firstValue = listValue.head();
        try {
            if (firstValue instanceof LongValue) {
                long[] longArray = new long[listValue.size()];
                Iterator iterator = listValue.iterator();
                for (int i = 0; i < listValue.size() && iterator.hasNext(); ++i) {
                    longArray[i] = ((LongValue)iterator.next()).longValue();
                }
                return Values.longArray((long[])longArray);
            }
            if (firstValue instanceof DoubleValue) {
                double[] doubleArray = new double[listValue.size()];
                Iterator iterator = listValue.iterator();
                for (int i = 0; i < listValue.size() && iterator.hasNext(); ++i) {
                    doubleArray[i] = ((DoubleValue)iterator.next()).doubleValue();
                }
                return Values.doubleArray((double[])doubleArray);
            }
            throw ValueConverter.failOnBadList((AnyValue)listValue);
        }
        catch (ClassCastException c) {
            throw ValueConverter.failOnBadList((AnyValue)listValue);
        }
    }

    private static IllegalArgumentException failOnBadList(AnyValue badList) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Only lists of uniformly typed numbers are supported as GDS node properties, but found an unsupported list `%s`.", (Object[])new Object[]{badList}));
    }

    private ValueConverter() {
    }
}

