/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.neo4j.gds.core.huge.UncompressedAdjacencyList;
import org.neo4j.gds.core.loading.AdjacencyListBuilder;
import org.neo4j.gds.core.loading.BumpAllocator;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class UncompressedAdjacencyListBuilder
implements AdjacencyListBuilder<long[], UncompressedAdjacencyList> {
    private final BumpAllocator<long[]> builder = new BumpAllocator<long[]>(Factory.INSTANCE);

    UncompressedAdjacencyListBuilder() {
    }

    public Allocator newAllocator() {
        return new Allocator(this.builder.newLocalAllocator());
    }

    @Override
    public AdjacencyListBuilder.Allocator<long[]> newPositionalAllocator() {
        return new PositionalAllocator(this.builder.newLocalPositionalAllocator());
    }

    @Override
    public UncompressedAdjacencyList build(HugeIntArray degrees, HugeLongArray offsets) {
        long[][] intoPages = this.builder.intoPages();
        this.reorder((PAGE[])intoPages, offsets, degrees);
        return new UncompressedAdjacencyList(intoPages, degrees, offsets);
    }

    public static final class PositionalAllocator
    implements AdjacencyListBuilder.Allocator<long[]> {
        private final BumpAllocator.LocalPositionalAllocator<long[]> allocator;

        private PositionalAllocator(BumpAllocator.LocalPositionalAllocator<long[]> allocator) {
            this.allocator = allocator;
        }

        @Override
        public void close() {
        }

        @Override
        public long write(long[] properties, int length, long address) {
            this.allocator.insertAt(address, properties, length);
            return address;
        }
    }

    public static final class Allocator
    implements AdjacencyListBuilder.Allocator<long[]> {
        private final BumpAllocator.LocalAllocator<long[]> allocator;

        private Allocator(BumpAllocator.LocalAllocator<long[]> allocator) {
            this.allocator = allocator;
        }

        @Override
        public void close() {
        }

        @Override
        public long write(long[] properties, int length, long address) {
            return this.allocator.insert(properties, length);
        }
    }

    private static enum Factory implements BumpAllocator.Factory<long[]>
    {
        INSTANCE;


        public long[][] newEmptyPages() {
            return new long[0][];
        }

        @Override
        public long[] newPage(int length) {
            return new long[length];
        }

        @Override
        public long[] copyOfPage(long[] longs, int length) {
            return Arrays.copyOf(longs, length);
        }

        @Override
        public int lengthOfPage(long[] longs) {
            return longs.length;
        }
    }
}

