/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.PropertyReader;
import org.neo4j.gds.core.loading.RelationshipsBatchBuffer;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.ThreadLocalSingleTypeRelationshipImporter;

@ParametersAreNonnullByDefault
@Generated(from="ThreadLocalSingleTypeRelationshipImporter.of", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class ThreadLocalSingleTypeRelationshipImporterBuilder {
    private static final long INIT_BIT_ADJACENCY_BUFFER = 1L;
    private static final long INIT_BIT_RELATIONSHIPS_BATCH_BUFFER = 2L;
    private static final long INIT_BIT_IMPORT_META_DATA = 4L;
    private static final long INIT_BIT_PROPERTY_READER = 8L;
    private long initBits = 15L;
    @Nullable
    private AdjacencyBuffer adjacencyBuffer;
    @Nullable
    private RelationshipsBatchBuffer relationshipsBatchBuffer;
    @Nullable
    private SingleTypeRelationshipImporter.ImportMetaData importMetaData;
    @Nullable
    private PropertyReader propertyReader;

    public final ThreadLocalSingleTypeRelationshipImporterBuilder adjacencyBuffer(AdjacencyBuffer adjacencyBuffer) {
        this.adjacencyBuffer = Objects.requireNonNull(adjacencyBuffer, "adjacencyBuffer");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final ThreadLocalSingleTypeRelationshipImporterBuilder relationshipsBatchBuffer(RelationshipsBatchBuffer relationshipsBatchBuffer) {
        this.relationshipsBatchBuffer = Objects.requireNonNull(relationshipsBatchBuffer, "relationshipsBatchBuffer");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final ThreadLocalSingleTypeRelationshipImporterBuilder importMetaData(SingleTypeRelationshipImporter.ImportMetaData importMetaData) {
        this.importMetaData = Objects.requireNonNull(importMetaData, "importMetaData");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final ThreadLocalSingleTypeRelationshipImporterBuilder propertyReader(PropertyReader propertyReader) {
        this.propertyReader = Objects.requireNonNull(propertyReader, "propertyReader");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public ThreadLocalSingleTypeRelationshipImporter build() {
        this.checkRequiredAttributes();
        return ThreadLocalSingleTypeRelationshipImporter.of(this.adjacencyBuffer, this.relationshipsBatchBuffer, this.importMetaData, this.propertyReader);
    }

    private boolean adjacencyBufferIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean relationshipsBatchBufferIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean importMetaDataIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean propertyReaderIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.adjacencyBufferIsSet()) {
            attributes.add("adjacencyBuffer");
        }
        if (!this.relationshipsBatchBufferIsSet()) {
            attributes.add("relationshipsBatchBuffer");
        }
        if (!this.importMetaDataIsSet()) {
            attributes.add("importMetaData");
        }
        if (!this.propertyReaderIsSet()) {
            attributes.add("propertyReader");
        }
        return "Cannot build of, some of required attributes are not set " + attributes;
    }
}

