/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.PropertyReader;
import org.neo4j.gds.core.loading.RelationshipsBatchBuffer;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.utils.RawValues;
import org.neo4j.gds.utils.StringFormatting;

@Value.Style(typeBuilder="ThreadLocalSingleTypeRelationshipImporterBuilder")
public abstract class ThreadLocalSingleTypeRelationshipImporter {
    private final AdjacencyBuffer adjacencyBuffer;
    private final RelationshipsBatchBuffer relationshipsBatchBuffer;
    final PropertyReader propertyReader;

    @Builder.Factory
    static ThreadLocalSingleTypeRelationshipImporter of(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, SingleTypeRelationshipImporter.ImportMetaData importMetaData, PropertyReader propertyReader) {
        Orientation orientation = importMetaData.projection().orientation();
        boolean loadProperties = importMetaData.projection().properties().hasMappings();
        if (orientation == Orientation.UNDIRECTED) {
            return loadProperties ? new UndirectedWithProperties(adjacencyBuffer, relationshipsBatchBuffer, propertyReader) : new Undirected(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }
        if (orientation == Orientation.NATURAL) {
            return loadProperties ? new NaturalWithProperties(adjacencyBuffer, relationshipsBatchBuffer, propertyReader) : new Natural(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }
        if (orientation == Orientation.REVERSE) {
            return loadProperties ? new ReverseWithProperties(adjacencyBuffer, relationshipsBatchBuffer, propertyReader) : new Reverse(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unexpected orientation: %s", (Object[])new Object[]{orientation}));
    }

    private ThreadLocalSingleTypeRelationshipImporter(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, PropertyReader propertyReader) {
        this.adjacencyBuffer = adjacencyBuffer;
        this.relationshipsBatchBuffer = relationshipsBatchBuffer;
        this.propertyReader = propertyReader;
    }

    public abstract long importRelationships();

    public RelationshipsBatchBuffer buffer() {
        return this.relationshipsBatchBuffer;
    }

    protected RelationshipsBatchBuffer sourceBuffer() {
        return this.relationshipsBatchBuffer;
    }

    protected AdjacencyBuffer targetBuffer() {
        return this.adjacencyBuffer;
    }

    protected int importRelationships(RelationshipsBatchBuffer sourceBuffer, long[] batch, long[][] properties, AdjacencyBuffer targetBuffer) {
        int batchLength = sourceBuffer.length();
        int[] offsets = sourceBuffer.spareInts();
        long[] targets = sourceBuffer.spareLongs();
        long prevSource = batch[0];
        int offset = 0;
        int nodesLength = 0;
        for (int i = 0; i < batchLength; i += 2) {
            long source = batch[i];
            long target = batch[1 + i];
            if (source > prevSource) {
                offsets[nodesLength++] = offset;
                prevSource = source;
            }
            targets[offset++] = target;
        }
        offsets[nodesLength++] = offset;
        targetBuffer.addAll(batch, targets, properties, offsets, nodesLength);
        return batchLength >> 1;
    }

    private static final class ReverseWithProperties
    extends ThreadLocalSingleTypeRelationshipImporter {
        private ReverseWithProperties(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, PropertyReader propertyReader) {
            super(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }

        @Override
        public long importRelationships() {
            int batchLength = this.sourceBuffer().length();
            long[] batch = this.sourceBuffer().sortByTarget();
            long[][] inProperties = this.propertyReader.readProperty(this.sourceBuffer().relationshipReferences(), this.sourceBuffer().propertyReferences(), batchLength / 2, this.targetBuffer().getPropertyKeyIds(), this.targetBuffer().getDefaultValues(), this.targetBuffer().getAggregations(), this.targetBuffer().atLeastOnePropertyToLoad());
            int importedIn = this.importRelationships(this.sourceBuffer(), batch, inProperties, this.targetBuffer());
            return RawValues.combineIntInt(importedIn, importedIn);
        }
    }

    private static final class Reverse
    extends ThreadLocalSingleTypeRelationshipImporter {
        private Reverse(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, PropertyReader propertyReader) {
            super(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }

        @Override
        public long importRelationships() {
            long[] batch = this.sourceBuffer().sortByTarget();
            return RawValues.combineIntInt(this.importRelationships(this.sourceBuffer(), batch, null, this.targetBuffer()), 0);
        }
    }

    private static final class NaturalWithProperties
    extends ThreadLocalSingleTypeRelationshipImporter {
        private NaturalWithProperties(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, PropertyReader propertyReader) {
            super(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }

        @Override
        public long importRelationships() {
            int batchLength = this.sourceBuffer().length();
            long[] batch = this.sourceBuffer().sortBySource();
            long[][] outProperties = this.propertyReader.readProperty(this.sourceBuffer().relationshipReferences(), this.sourceBuffer().propertyReferences(), batchLength / 2, this.targetBuffer().getPropertyKeyIds(), this.targetBuffer().getDefaultValues(), this.targetBuffer().getAggregations(), this.targetBuffer().atLeastOnePropertyToLoad());
            int importedOut = this.importRelationships(this.sourceBuffer(), batch, outProperties, this.targetBuffer());
            return RawValues.combineIntInt(importedOut, importedOut);
        }
    }

    private static final class Natural
    extends ThreadLocalSingleTypeRelationshipImporter {
        private Natural(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, PropertyReader propertyReader) {
            super(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }

        @Override
        public long importRelationships() {
            long[] batch = this.sourceBuffer().sortBySource();
            return RawValues.combineIntInt(this.importRelationships(this.sourceBuffer(), batch, null, this.targetBuffer()), 0);
        }
    }

    private static final class UndirectedWithProperties
    extends ThreadLocalSingleTypeRelationshipImporter {
        private UndirectedWithProperties(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, PropertyReader propertyReader) {
            super(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }

        @Override
        public long importRelationships() {
            int batchLength = this.sourceBuffer().length();
            long[] batch = this.sourceBuffer().sortBySource();
            long[][] outProperties = this.propertyReader.readProperty(this.sourceBuffer().relationshipReferences(), this.sourceBuffer().propertyReferences(), batchLength / 2, this.targetBuffer().getPropertyKeyIds(), this.targetBuffer().getDefaultValues(), this.targetBuffer().getAggregations(), this.targetBuffer().atLeastOnePropertyToLoad());
            int importedOut = this.importRelationships(this.sourceBuffer(), batch, outProperties, this.targetBuffer());
            batch = this.sourceBuffer().sortByTarget();
            long[][] inProperties = this.propertyReader.readProperty(this.sourceBuffer().relationshipReferences(), this.sourceBuffer().propertyReferences(), batchLength / 2, this.targetBuffer().getPropertyKeyIds(), this.targetBuffer().getDefaultValues(), this.targetBuffer().getAggregations(), this.targetBuffer().atLeastOnePropertyToLoad());
            int importedIn = this.importRelationships(this.sourceBuffer(), batch, inProperties, this.targetBuffer());
            return RawValues.combineIntInt(importedOut + importedIn, importedOut + importedIn);
        }
    }

    private static final class Undirected
    extends ThreadLocalSingleTypeRelationshipImporter {
        private Undirected(AdjacencyBuffer adjacencyBuffer, RelationshipsBatchBuffer relationshipsBatchBuffer, PropertyReader propertyReader) {
            super(adjacencyBuffer, relationshipsBatchBuffer, propertyReader);
        }

        @Override
        public long importRelationships() {
            long[] batch = this.sourceBuffer().sortBySource();
            int importedOut = this.importRelationships(this.sourceBuffer(), batch, null, this.targetBuffer());
            batch = this.sourceBuffer().sortByTarget();
            int importedIn = this.importRelationships(this.sourceBuffer(), batch, null, this.targetBuffer());
            return RawValues.combineIntInt(importedOut + importedIn, 0);
        }
    }
}

