/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.loading.ThreadLocalRelationshipsCompressor;

final class ThreadLocalRelationshipsBuilder {
    private final ReentrantLock lock = new ReentrantLock();
    private final AdjacencyCompressorFactory adjacencyCompressor;

    ThreadLocalRelationshipsBuilder(AdjacencyCompressorFactory compressorBlueprint) {
        this.adjacencyCompressor = compressorBlueprint;
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    boolean isLockedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    ThreadLocalRelationshipsCompressor intoCompressor() {
        AdjacencyCompressor compressor = this.adjacencyCompressor.createCompressor();
        return new ThreadLocalRelationshipsCompressor(compressor);
    }
}

