/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;

@ParametersAreNonnullByDefault
@Generated(from="SingleTypeRelationshipImporter.of", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class SingleTypeRelationshipImporterBuilder {
    private static final long INIT_BIT_IMPORT_META_DATA = 1L;
    private static final long INIT_BIT_NODE_COUNT_SUPPLIER = 2L;
    private static final long INIT_BIT_VALIDATE_RELATIONSHIPS = 4L;
    private static final long INIT_BIT_IMPORT_SIZING = 8L;
    private long initBits = 15L;
    @Nullable
    private SingleTypeRelationshipImporter.ImportMetaData importMetaData;
    @Nullable
    private LongSupplier nodeCountSupplier;
    private boolean validateRelationships;
    @Nullable
    private ImportSizing importSizing;

    public final SingleTypeRelationshipImporterBuilder importMetaData(SingleTypeRelationshipImporter.ImportMetaData importMetaData) {
        this.importMetaData = Objects.requireNonNull(importMetaData, "importMetaData");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final SingleTypeRelationshipImporterBuilder nodeCountSupplier(LongSupplier nodeCountSupplier) {
        this.nodeCountSupplier = Objects.requireNonNull(nodeCountSupplier, "nodeCountSupplier");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final SingleTypeRelationshipImporterBuilder validateRelationships(boolean validateRelationships) {
        this.validateRelationships = validateRelationships;
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final SingleTypeRelationshipImporterBuilder importSizing(ImportSizing importSizing) {
        this.importSizing = Objects.requireNonNull(importSizing, "importSizing");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public SingleTypeRelationshipImporter build() {
        this.checkRequiredAttributes();
        return SingleTypeRelationshipImporter.of(this.importMetaData, this.nodeCountSupplier, this.validateRelationships, this.importSizing);
    }

    private boolean importMetaDataIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean nodeCountSupplierIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean validateRelationshipsIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean importSizingIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.importMetaDataIsSet()) {
            attributes.add("importMetaData");
        }
        if (!this.nodeCountSupplierIsSet()) {
            attributes.add("nodeCountSupplier");
        }
        if (!this.validateRelationshipsIsSet()) {
            attributes.add("validateRelationships");
        }
        if (!this.importSizingIsSet()) {
            attributes.add("importSizing");
        }
        return "Cannot build of, some of required attributes are not set " + attributes;
    }
}

