/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.compress.AdjacencyListBehavior;
import org.neo4j.gds.core.compress.AdjacencyListsWithProperties;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.AdjacencyBufferBuilder;
import org.neo4j.gds.core.loading.ImmutableImportMetaData;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.PropertyReader;
import org.neo4j.gds.core.loading.RelationshipsBatchBuffer;
import org.neo4j.gds.core.loading.ThreadLocalSingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.ThreadLocalSingleTypeRelationshipImporterBuilder;
import org.neo4j.kernel.api.KernelTransaction;

@Value.Style(typeBuilder="SingleTypeRelationshipImporterBuilder")
public final class SingleTypeRelationshipImporter {
    private final AdjacencyCompressorFactory adjacencyCompressorFactory;
    private final ImportMetaData importMetaData;
    private final int typeId;
    private final AdjacencyBuffer adjacencyBuffer;
    private final boolean validateRelationships;

    @Builder.Factory
    public static SingleTypeRelationshipImporter of(ImportMetaData importMetaData, LongSupplier nodeCountSupplier, boolean validateRelationships, ImportSizing importSizing) {
        AdjacencyCompressorFactory adjacencyCompressorFactory = AdjacencyListBehavior.asConfigured(nodeCountSupplier, importMetaData.projection().properties(), importMetaData.aggregations());
        AdjacencyBuffer adjacencyBuffer = new AdjacencyBufferBuilder().importMetaData(importMetaData).importSizing(importSizing).adjacencyCompressorFactory(adjacencyCompressorFactory).build();
        return new SingleTypeRelationshipImporter(adjacencyCompressorFactory, adjacencyBuffer, importMetaData, importMetaData.typeTokenId(), validateRelationships);
    }

    private SingleTypeRelationshipImporter(AdjacencyCompressorFactory adjacencyCompressorFactory, AdjacencyBuffer adjacencyBuffer, ImportMetaData importMetaData, int typeToken, boolean validateRelationships) {
        this.adjacencyCompressorFactory = adjacencyCompressorFactory;
        this.importMetaData = importMetaData;
        this.typeId = typeToken;
        this.adjacencyBuffer = adjacencyBuffer;
        this.validateRelationships = validateRelationships;
    }

    public Collection<AdjacencyBuffer.AdjacencyListBuilderTask> adjacencyListBuilderTasks(Optional<AdjacencyCompressor.ValueMapper> mapper) {
        return this.adjacencyBuffer.adjacencyListBuilderTasks(mapper, Optional.empty());
    }

    public Collection<AdjacencyBuffer.AdjacencyListBuilderTask> adjacencyListBuilderTasks(Optional<AdjacencyCompressor.ValueMapper> mapper, Optional<LongConsumer> drainCountConsumer) {
        return this.adjacencyBuffer.adjacencyListBuilderTasks(mapper, drainCountConsumer);
    }

    public ThreadLocalSingleTypeRelationshipImporter threadLocalImporter(PartialIdMap idMap, int bulkSize, PropertyReader propertyReader) {
        return new ThreadLocalSingleTypeRelationshipImporterBuilder().adjacencyBuffer(this.adjacencyBuffer).relationshipsBatchBuffer(this.createBuffer(idMap, bulkSize)).importMetaData(this.importMetaData).propertyReader(propertyReader).build();
    }

    ThreadLocalSingleTypeRelationshipImporter threadLocalImporter(PartialIdMap idMap, int bulkSize, KernelTransaction kernelTransaction) {
        boolean loadProperties = this.importMetaData.projection().properties().hasMappings();
        PropertyReader propertyReader = loadProperties ? PropertyReader.storeBacked(kernelTransaction) : (relationshipReferences, propertyReferences, numberOfReferences, propertyKeyIds, defaultValues, aggregations, atLeastOnePropertyToLoad) -> new long[propertyKeyIds.length][0];
        return new ThreadLocalSingleTypeRelationshipImporterBuilder().adjacencyBuffer(this.adjacencyBuffer).relationshipsBatchBuffer(this.createBuffer(idMap, bulkSize)).importMetaData(this.importMetaData).propertyReader(propertyReader).build();
    }

    @NotNull
    private RelationshipsBatchBuffer createBuffer(PartialIdMap idMap, int bulkSize) {
        return new RelationshipsBatchBuffer(idMap, this.typeId, bulkSize, this.validateRelationships);
    }

    public AdjacencyListsWithProperties build() {
        return this.adjacencyCompressorFactory.build();
    }

    @ValueClass
    public static interface SingleTypeRelationshipImportContext {
        public RelationshipType relationshipType();

        public RelationshipProjection relationshipProjection();

        public SingleTypeRelationshipImporter singleTypeRelationshipImporter();
    }

    @ValueClass
    public static interface ImportMetaData {
        public RelationshipProjection projection();

        public Aggregation[] aggregations();

        public int[] propertyKeyIds();

        public double[] defaultValues();

        public int typeTokenId();

        public static ImportMetaData of(RelationshipProjection projection, int typeTokenId, Map<String, Integer> relationshipPropertyTokens) {
            return ImmutableImportMetaData.builder().projection(projection).aggregations(ImportMetaData.aggregations(projection)).propertyKeyIds(ImportMetaData.propertyKeyIds(projection, relationshipPropertyTokens)).defaultValues(ImportMetaData.defaultValues(projection)).typeTokenId(typeTokenId).build();
        }

        private static double[] defaultValues(RelationshipProjection projection) {
            return projection.properties().mappings().stream().mapToDouble(propertyMapping -> propertyMapping.defaultValue().doubleValue()).toArray();
        }

        private static int[] propertyKeyIds(RelationshipProjection projection, Map<String, Integer> relationshipPropertyTokens) {
            return projection.properties().mappings().stream().mapToInt(mapping -> (Integer)relationshipPropertyTokens.get(mapping.neoPropertyKey())).toArray();
        }

        private static Aggregation[] aggregations(RelationshipProjection projection) {
            List propertyMappings = projection.properties().mappings();
            Aggregation[] aggregations = (Aggregation[])propertyMappings.stream().map(PropertyMapping::aggregation).map(Aggregation::resolve).toArray(Aggregation[]::new);
            if (propertyMappings.isEmpty()) {
                aggregations = new Aggregation[]{Aggregation.resolve((Aggregation)projection.aggregation())};
            }
            return aggregations;
        }
    }
}

