/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.BatchNodeIterable;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

final class SingleLabelInformation
implements LabelInformation {
    private final NodeLabel label;
    private final Set<NodeLabel> labelSet;

    private SingleLabelInformation(NodeLabel label) {
        this.label = label;
        this.labelSet = Set.of(label);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Set<NodeLabel> labelSet() {
        return this.labelSet;
    }

    @Override
    public void forEach(LabelInformation.LabelInformationConsumer consumer) {
        throw new UnsupportedOperationException("There are not BitSets in empty label information");
    }

    @Override
    public LabelInformation filter(Collection<NodeLabel> nodeLabels) {
        return this;
    }

    @Override
    public BitSet unionBitSet(Collection<NodeLabel> nodeLabels, long nodeCount) {
        throw new UnsupportedOperationException("Union with empty label information is not supported");
    }

    @Override
    public boolean hasLabel(long nodeId, NodeLabel nodeLabel) {
        return nodeLabel.equals((Object)this.label);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.labelSet;
    }

    @Override
    public List<NodeLabel> nodeLabelsForNodeId(long nodeId) {
        return List.of(this.label);
    }

    @Override
    public void forEachNodeLabel(long nodeId, IdMap.NodeLabelConsumer consumer) {
        consumer.accept(this.label);
    }

    @Override
    public void validateNodeLabelFilter(Collection<NodeLabel> nodeLabels) {
        List invalidLabels = nodeLabels.stream().filter((? super T filterLabel) -> !filterLabel.equals((Object)this.label)).collect(Collectors.toList());
        if (!invalidLabels.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Specified labels %s do not correspond to any of the node projections %s.", (Object[])new Object[]{invalidLabels, this.labelSet()}));
        }
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Collection<NodeLabel> labels, long nodeCount) {
        if (labels.size() == 1 && (labels.contains(this.label) || labels.contains(NodeLabel.ALL_NODES))) {
            return new BatchNodeIterable.IdIterator(nodeCount);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unknown labels: %s", (Object[])new Object[]{StringJoining.join(labels.stream().map(ElementIdentifier::name))}));
    }

    static final class Builder
    implements LabelInformation.Builder {
        private final NodeLabel label;

        Builder(NodeLabel label) {
            this.label = label;
        }

        @Override
        public void addNodeIdToLabel(NodeLabel nodeLabel, long nodeId) {
            throw new UnsupportedOperationException("This builder does not support adding labels");
        }

        @Override
        public LabelInformation build(long nodeCount, LongUnaryOperator mappedIdFn) {
            return new SingleLabelInformation(this.label);
        }
    }
}

