/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.ScanningRelationshipsImporter;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

@ParametersAreNonnullByDefault
@Generated(from="ScanningRelationshipsImporter.scanningRelationshipsImporter", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class ScanningRelationshipsImporterBuilder {
    private static final long INIT_BIT_GRAPH_PROJECT_CONFIG = 1L;
    private static final long INIT_BIT_LOADING_CONTEXT = 2L;
    private static final long INIT_BIT_DIMENSIONS = 4L;
    private static final long INIT_BIT_PROGRESS_TRACKER = 8L;
    private static final long INIT_BIT_ID_MAP = 16L;
    private static final long INIT_BIT_CONCURRENCY = 32L;
    private long initBits = 63L;
    @Nullable
    private GraphProjectFromStoreConfig graphProjectConfig;
    @Nullable
    private GraphLoaderContext loadingContext;
    @Nullable
    private GraphDimensions dimensions;
    @Nullable
    private ProgressTracker progressTracker;
    @Nullable
    private IdMap idMap;
    private int concurrency;

    public final ScanningRelationshipsImporterBuilder graphProjectConfig(GraphProjectFromStoreConfig graphProjectConfig) {
        this.graphProjectConfig = Objects.requireNonNull(graphProjectConfig, "graphProjectConfig");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final ScanningRelationshipsImporterBuilder loadingContext(GraphLoaderContext loadingContext) {
        this.loadingContext = Objects.requireNonNull(loadingContext, "loadingContext");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final ScanningRelationshipsImporterBuilder dimensions(GraphDimensions dimensions) {
        this.dimensions = Objects.requireNonNull(dimensions, "dimensions");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final ScanningRelationshipsImporterBuilder progressTracker(ProgressTracker progressTracker) {
        this.progressTracker = Objects.requireNonNull(progressTracker, "progressTracker");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public final ScanningRelationshipsImporterBuilder idMap(IdMap idMap) {
        this.idMap = Objects.requireNonNull(idMap, "idMap");
        this.initBits &= 0xFFFFFFFFFFFFFFEFL;
        return this;
    }

    public final ScanningRelationshipsImporterBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        this.initBits &= 0xFFFFFFFFFFFFFFDFL;
        return this;
    }

    public ScanningRelationshipsImporter build() {
        this.checkRequiredAttributes();
        return ScanningRelationshipsImporter.scanningRelationshipsImporter(this.graphProjectConfig, this.loadingContext, this.dimensions, this.progressTracker, this.idMap, this.concurrency);
    }

    private boolean graphProjectConfigIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean loadingContextIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean dimensionsIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean progressTrackerIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private boolean idMapIsSet() {
        return (this.initBits & 0x10L) == 0L;
    }

    private boolean concurrencyIsSet() {
        return (this.initBits & 0x20L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.graphProjectConfigIsSet()) {
            attributes.add("graphProjectConfig");
        }
        if (!this.loadingContextIsSet()) {
            attributes.add("loadingContext");
        }
        if (!this.dimensionsIsSet()) {
            attributes.add("dimensions");
        }
        if (!this.progressTrackerIsSet()) {
            attributes.add("progressTracker");
        }
        if (!this.idMapIsSet()) {
            attributes.add("idMap");
        }
        if (!this.concurrencyIsSet()) {
            attributes.add("concurrency");
        }
        return "Cannot build scanningRelationshipsImporter, some of required attributes are not set " + attributes;
    }
}

