/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.List;
import java.util.stream.Collectors;
import org.immutables.builder.Builder;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.ImmutableSingleTypeRelationshipImportContext;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.RecordScannerTaskRunner;
import org.neo4j.gds.core.loading.RelationshipReference;
import org.neo4j.gds.core.loading.RelationshipScanCursorBasedScanner;
import org.neo4j.gds.core.loading.RelationshipsAndProperties;
import org.neo4j.gds.core.loading.RelationshipsScannerTask;
import org.neo4j.gds.core.loading.ScanningRecordsImporter;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporterBuilder;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public final class ScanningRelationshipsImporter
extends ScanningRecordsImporter<RelationshipReference, RelationshipsAndProperties> {
    private final GraphProjectFromStoreConfig graphProjectConfig;
    private final GraphLoaderContext loadingContext;
    private final IdMap idMap;
    private List<SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext> importContexts;

    @Builder.Factory
    static ScanningRelationshipsImporter scanningRelationshipsImporter(GraphProjectFromStoreConfig graphProjectConfig, GraphLoaderContext loadingContext, GraphDimensions dimensions, ProgressTracker progressTracker, IdMap idMap, int concurrency) {
        return new ScanningRelationshipsImporter(graphProjectConfig, loadingContext, dimensions, progressTracker, idMap, concurrency);
    }

    private ScanningRelationshipsImporter(GraphProjectFromStoreConfig graphProjectConfig, GraphLoaderContext loadingContext, GraphDimensions dimensions, ProgressTracker progressTracker, IdMap idMap, int concurrency) {
        super(RelationshipScanCursorBasedScanner.FACTORY, loadingContext, dimensions, progressTracker, concurrency);
        this.graphProjectConfig = graphProjectConfig;
        this.loadingContext = loadingContext;
        this.idMap = idMap;
    }

    @Override
    public RecordScannerTaskRunner.RecordScannerTaskFactory recordScannerTaskFactory(long nodeCount, ImportSizing sizing, StoreScanner<RelationshipReference> storeScanner) {
        this.importContexts = this.graphProjectConfig.relationshipProjections().projections().entrySet().stream().map(entry -> {
            RelationshipType relationshipType = (RelationshipType)entry.getKey();
            RelationshipProjection projection = (RelationshipProjection)entry.getValue();
            SingleTypeRelationshipImporter.ImportMetaData importMetaData = SingleTypeRelationshipImporter.ImportMetaData.of(projection, this.dimensions.relationshipTypeTokenMapping().get((Object)relationshipType), this.dimensions.relationshipPropertyTokens());
            SingleTypeRelationshipImporter importerFactory = new SingleTypeRelationshipImporterBuilder().importMetaData(importMetaData).nodeCountSupplier(() -> ((GraphDimensions)this.dimensions).nodeCount()).importSizing(sizing).validateRelationships(this.graphProjectConfig.validateRelationships()).build();
            return ImmutableSingleTypeRelationshipImportContext.builder().relationshipType(relationshipType).relationshipProjection(projection).singleTypeRelationshipImporter(importerFactory).build();
        }).collect(Collectors.toList());
        return RelationshipsScannerTask.factory(this.loadingContext, this.progressTracker, this.idMap, storeScanner, this.importContexts.stream().map(SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext::singleTypeRelationshipImporter).collect(Collectors.toList()));
    }

    @Override
    public RelationshipsAndProperties build() {
        return RelationshipsAndProperties.of(this.importContexts);
    }
}

