/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.RecordScannerTaskRunner;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StringFormatting;

public abstract class ScanningRecordsImporter<Record, T> {
    static final BigInteger A_BILLION = BigInteger.valueOf(1000000000L);
    private final StoreScanner.Factory<Record> storeScannerFactory;
    protected final ExecutorService executorService;
    protected final TransactionContext transaction;
    protected final GraphDimensions dimensions;
    protected final ProgressTracker progressTracker;
    protected final int concurrency;

    ScanningRecordsImporter(StoreScanner.Factory<Record> storeScannerFactory, GraphLoaderContext loadingContext, GraphDimensions dimensions, ProgressTracker progressTracker, int concurrency) {
        this.storeScannerFactory = storeScannerFactory;
        this.transaction = loadingContext.transactionContext();
        this.dimensions = dimensions;
        this.executorService = loadingContext.executor();
        this.progressTracker = progressTracker;
        this.concurrency = concurrency;
    }

    public final T call() {
        long nodeCount = this.dimensions.nodeCount();
        ImportSizing sizing = ImportSizing.of(this.concurrency, nodeCount);
        int threadCount = sizing.threadCount();
        try (StoreScanner<Record> storeScanner = this.storeScannerFactory.newScanner(100, this.transaction);){
            this.progressTracker.beginSubTask("Store Scan");
            this.progressTracker.logDebug(StringFormatting.formatWithLocale((String)"Start using %s", (Object[])new Object[]{storeScanner.getClass().getSimpleName()}));
            RecordScannerTaskRunner.RecordScannerTaskFactory taskFactory = this.recordScannerTaskFactory(nodeCount, sizing, storeScanner);
            RecordScannerTaskRunner taskRunner = new RecordScannerTaskRunner(threadCount, taskFactory);
            RecordScannerTaskRunner.ImportResult importResult = taskRunner.runImport(this.executorService);
            long requiredBytes = storeScanner.storeSize(this.dimensions);
            long recordsImported = importResult.importedRecords();
            long propertiesImported = importResult.importedProperties();
            BigInteger bigNanos = BigInteger.valueOf(importResult.durationNanos());
            double tookInSeconds = new BigDecimal(bigNanos).divide(new BigDecimal(A_BILLION), 9, RoundingMode.CEILING).doubleValue();
            long bytesPerSecond = A_BILLION.multiply(BigInteger.valueOf(requiredBytes)).divide(bigNanos).longValueExact();
            this.progressTracker.logDebug(StringFormatting.formatWithLocale((String)"Imported %,d records and %,d properties from %s (%,d bytes); took %.3f s, %,.2f %1$ss/s, %s/s (%,d bytes/s) (per thread: %,.2f %1$ss/s, %s/s (%,d bytes/s))", (Object[])new Object[]{recordsImported, propertiesImported, MemoryUsage.humanReadable((long)requiredBytes), requiredBytes, tookInSeconds, (double)recordsImported / tookInSeconds, MemoryUsage.humanReadable((long)bytesPerSecond), bytesPerSecond, (double)recordsImported / tookInSeconds / (double)threadCount, MemoryUsage.humanReadable((long)(bytesPerSecond / (long)threadCount)), bytesPerSecond / (long)threadCount}));
            this.progressTracker.endSubTask("Store Scan");
        }
        return this.build();
    }

    public abstract RecordScannerTaskRunner.RecordScannerTaskFactory recordScannerTaskFactory(long var1, ImportSizing var3, StoreScanner<Record> var4);

    public abstract T build();
}

