/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.ScanningNodesImporter;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

@ParametersAreNonnullByDefault
@Generated(from="ScanningNodesImporter.scanningNodesImporter", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class ScanningNodesImporterBuilder {
    private static final long INIT_BIT_GRAPH_PROJECT_CONFIG = 1L;
    private static final long INIT_BIT_LOADING_CONTEXT = 2L;
    private static final long INIT_BIT_DIMENSIONS = 4L;
    private static final long INIT_BIT_PROGRESS_TRACKER = 8L;
    private static final long INIT_BIT_CONCURRENCY = 16L;
    private long initBits = 31L;
    @Nullable
    private GraphProjectFromStoreConfig graphProjectConfig;
    @Nullable
    private GraphLoaderContext loadingContext;
    @Nullable
    private GraphDimensions dimensions;
    @Nullable
    private ProgressTracker progressTracker;
    private int concurrency;

    public final ScanningNodesImporterBuilder graphProjectConfig(GraphProjectFromStoreConfig graphProjectConfig) {
        this.graphProjectConfig = Objects.requireNonNull(graphProjectConfig, "graphProjectConfig");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final ScanningNodesImporterBuilder loadingContext(GraphLoaderContext loadingContext) {
        this.loadingContext = Objects.requireNonNull(loadingContext, "loadingContext");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final ScanningNodesImporterBuilder dimensions(GraphDimensions dimensions) {
        this.dimensions = Objects.requireNonNull(dimensions, "dimensions");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final ScanningNodesImporterBuilder progressTracker(ProgressTracker progressTracker) {
        this.progressTracker = Objects.requireNonNull(progressTracker, "progressTracker");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public final ScanningNodesImporterBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        this.initBits &= 0xFFFFFFFFFFFFFFEFL;
        return this;
    }

    public ScanningNodesImporter build() {
        this.checkRequiredAttributes();
        return ScanningNodesImporter.scanningNodesImporter(this.graphProjectConfig, this.loadingContext, this.dimensions, this.progressTracker, this.concurrency);
    }

    private boolean graphProjectConfigIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean loadingContextIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean dimensionsIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean progressTrackerIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private boolean concurrencyIsSet() {
        return (this.initBits & 0x10L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.graphProjectConfigIsSet()) {
            attributes.add("graphProjectConfig");
        }
        if (!this.loadingContextIsSet()) {
            attributes.add("loadingContext");
        }
        if (!this.dimensionsIsSet()) {
            attributes.add("dimensions");
        }
        if (!this.progressTrackerIsSet()) {
            attributes.add("progressTracker");
        }
        if (!this.concurrencyIsSet()) {
            attributes.add("concurrency");
        }
        return "Cannot build scanningNodesImporter, some of required attributes are not set " + attributes;
    }
}

