/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.IntObjectMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.builder.Builder;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.IdMapBehaviorServiceProvider;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.IdMapAndProperties;
import org.neo4j.gds.core.loading.IdMapBuilder;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.IndexPropertyMappings;
import org.neo4j.gds.core.loading.IndexedNodePropertyImporter;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.loading.NativeNodePropertyImporter;
import org.neo4j.gds.core.loading.NodeImporter;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.gds.core.loading.NodeScannerFactory;
import org.neo4j.gds.core.loading.NodesScannerTask;
import org.neo4j.gds.core.loading.RecordScannerTaskRunner;
import org.neo4j.gds.core.loading.ScanningRecordsImporter;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.core.loading.nodeproperties.NodePropertiesFromStoreBuilder;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.GdsFeatureToggles;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.logging.Log;

public final class ScanningNodesImporter
extends ScanningRecordsImporter<NodeReference, IdMapAndProperties> {
    private final IndexPropertyMappings.LoadablePropertyMappings propertyMappings;
    private final TerminationFlag terminationFlag;
    private final IdMapBuilder idMapBuilder;
    private final LabelInformation.Builder labelInformationBuilder;
    @Nullable
    private final NativeNodePropertyImporter nodePropertyImporter;

    @Builder.Factory
    public static ScanningNodesImporter scanningNodesImporter(GraphProjectFromStoreConfig graphProjectConfig, GraphLoaderContext loadingContext, GraphDimensions dimensions, ProgressTracker progressTracker, int concurrency) {
        LabelInformation.Builder labelInformationBuilder;
        long expectedCapacity = dimensions.highestPossibleNodeCount();
        IntObjectMap labelTokenNodeLabelMapping = dimensions.tokenNodeLabelMapping();
        StoreScanner.Factory<NodeReference> scannerFactory = ScanningNodesImporter.scannerFactory(loadingContext.transactionContext(), dimensions, loadingContext.log());
        IdMapBuilder idMapBuilder = IdMapBehaviorServiceProvider.idMapBehavior().create(concurrency, Optional.of(dimensions.highestPossibleNodeCount()), Optional.of(dimensions.nodeCount()));
        if (graphProjectConfig.nodeProjections().allProjections().size() == 1) {
            NodeLabel singleLabel = (NodeLabel)graphProjectConfig.nodeProjections().projections().keySet().iterator().next();
            labelInformationBuilder = LabelInformation.single(singleLabel);
        } else {
            labelInformationBuilder = LabelInformation.builder(expectedCapacity, (IntObjectMap<List<NodeLabel>>)labelTokenNodeLabelMapping);
        }
        IndexPropertyMappings.LoadablePropertyMappings propertyMappings = IndexPropertyMappings.prepareProperties(graphProjectConfig, dimensions, loadingContext.transactionContext());
        NativeNodePropertyImporter nodePropertyImporter = ScanningNodesImporter.initializeNodePropertyImporter(propertyMappings, dimensions, concurrency);
        return new ScanningNodesImporter(scannerFactory, loadingContext, dimensions, progressTracker, concurrency, propertyMappings, nodePropertyImporter, idMapBuilder, labelInformationBuilder);
    }

    private ScanningNodesImporter(StoreScanner.Factory<NodeReference> scannerFactory, GraphLoaderContext loadingContext, GraphDimensions dimensions, ProgressTracker progressTracker, int concurrency, IndexPropertyMappings.LoadablePropertyMappings propertyMappings, @Nullable NativeNodePropertyImporter nodePropertyImporter, IdMapBuilder idMapBuilder, LabelInformation.Builder labelInformationBuilder) {
        super(scannerFactory, loadingContext, dimensions, progressTracker, concurrency);
        this.terminationFlag = loadingContext.terminationFlag();
        this.propertyMappings = propertyMappings;
        this.nodePropertyImporter = nodePropertyImporter;
        this.idMapBuilder = idMapBuilder;
        this.labelInformationBuilder = labelInformationBuilder;
    }

    private static StoreScanner.Factory<NodeReference> scannerFactory(TransactionContext transaction, GraphDimensions dimensions, Log log) {
        IntObjectMap tokenNodeLabelMapping = dimensions.tokenNodeLabelMapping();
        assert (tokenNodeLabelMapping != null) : "Only null in Cypher loader";
        int[] labelIds = tokenNodeLabelMapping.keys().toArray();
        return NodeScannerFactory.create(transaction, labelIds, log);
    }

    @Override
    public RecordScannerTaskRunner.RecordScannerTaskFactory recordScannerTaskFactory(long nodeCount, ImportSizing sizing, StoreScanner<NodeReference> storeScanner) {
        NodeImporter nodeImporter = new NodeImporter(this.idMapBuilder, this.labelInformationBuilder, (IntObjectMap<List<NodeLabel>>)this.dimensions.tokenNodeLabelMapping(), this.nodePropertyImporter != null);
        return NodesScannerTask.factory(this.transaction, storeScanner, this.dimensions.highestPossibleNodeCount(), this.dimensions.nodeLabelTokens(), this.progressTracker, nodeImporter, this.nodePropertyImporter, this.terminationFlag);
    }

    @Override
    public IdMapAndProperties build() {
        HashMap<PropertyMapping, NodePropertyValues> nodeProperties;
        IdMap idMap = this.idMapBuilder.build(this.labelInformationBuilder, Math.max(this.dimensions.highestPossibleNodeCount() - 1L, 0L), this.concurrency);
        Map<Object, Object> map = nodeProperties = this.nodePropertyImporter == null ? new HashMap() : this.nodePropertyImporter.result(idMap);
        if (!this.propertyMappings.indexedProperties().isEmpty()) {
            this.importPropertiesFromIndex(idMap, nodeProperties);
        }
        return IdMapAndProperties.of(idMap, nodeProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPropertiesFromIndex(IdMap idMap, Map<PropertyMapping, NodePropertyValues> nodeProperties) {
        long indexStart = System.nanoTime();
        try {
            this.progressTracker.beginSubTask("Property Index Scan");
            boolean parallelIndexScan = GdsFeatureToggles.USE_PARALLEL_PROPERTY_VALUE_INDEX.isEnabled();
            int concurrency = parallelIndexScan ? this.concurrency : 1;
            HashMap buildersByPropertyKey = new HashMap();
            this.propertyMappings.indexedProperties().values().stream().flatMap(propertyMappings -> propertyMappings.mappings().stream()).forEach(propertyMapping -> buildersByPropertyKey.put(propertyMapping.property(), NodePropertiesFromStoreBuilder.of(propertyMapping.property().defaultValue(), concurrency)));
            List indexScanningImporters = this.propertyMappings.indexedProperties().entrySet().stream().flatMap(labelAndProperties -> ((IndexPropertyMappings.IndexedPropertyMappings)labelAndProperties.getValue()).mappings().stream().map(mappingAndIndex -> new IndexedNodePropertyImporter(concurrency, this.transaction, (NodeLabel)labelAndProperties.getKey(), mappingAndIndex.property(), mappingAndIndex.index(), idMap, this.progressTracker, this.terminationFlag, this.executorService, (NodePropertiesFromStoreBuilder)buildersByPropertyKey.get(mappingAndIndex.property())))).collect(Collectors.toList());
            if (!parallelIndexScan) {
                ParallelUtil.run(indexScanningImporters, this.executorService);
            }
            long recordsImported = 0L;
            for (IndexedNodePropertyImporter indexedNodePropertyImporter : indexScanningImporters) {
                if (!parallelIndexScan) continue;
                indexedNodePropertyImporter.run();
            }
            for (Map.Entry entry : buildersByPropertyKey.entrySet()) {
                NodePropertyValues propertyValues = ((NodePropertiesFromStoreBuilder)entry.getValue()).build(idMap);
                nodeProperties.put((PropertyMapping)entry.getKey(), propertyValues);
                recordsImported += propertyValues.size();
            }
            long tookNanos = System.nanoTime() - indexStart;
            BigInteger bigNanos = BigInteger.valueOf(tookNanos);
            double tookInSeconds = new BigDecimal(bigNanos).divide(new BigDecimal(A_BILLION), 9, RoundingMode.CEILING).doubleValue();
            double recordsPerSecond = new BigDecimal(A_BILLION).multiply(BigDecimal.valueOf(recordsImported)).divide(new BigDecimal(bigNanos), 9, RoundingMode.CEILING).doubleValue();
            this.progressTracker.logDebug(StringFormatting.formatWithLocale((String)"Property Index Scan: Imported %,d properties; took %.3f s, %,.2f Properties/s", (Object[])new Object[]{recordsImported, tookInSeconds, recordsPerSecond}));
        }
        finally {
            this.progressTracker.endSubTask("Property Index Scan");
        }
    }

    @Nullable
    private static NativeNodePropertyImporter initializeNodePropertyImporter(IndexPropertyMappings.LoadablePropertyMappings propertyMappings, GraphDimensions dimensions, int concurrency) {
        Map<NodeLabel, PropertyMappings> propertyMappingsByLabel = propertyMappings.storedProperties();
        boolean loadProperties = propertyMappingsByLabel.values().stream().anyMatch(mappings -> mappings.numberOfMappings() > 0);
        if (loadProperties) {
            return NativeNodePropertyImporter.builder().concurrency(concurrency).dimensions(dimensions).propertyMappings(propertyMappingsByLabel).build();
        }
        return null;
    }
}

