/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.CompositeRelationshipsBatchBuffer;
import org.neo4j.gds.core.loading.RecordScannerTask;
import org.neo4j.gds.core.loading.RecordScannerTaskRunner;
import org.neo4j.gds.core.loading.RecordsBatchBuffer;
import org.neo4j.gds.core.loading.RelationshipReference;
import org.neo4j.gds.core.loading.RelationshipsBatchBuffer;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.core.loading.ThreadLocalSingleTypeRelationshipImporter;
import org.neo4j.gds.core.utils.RawValues;
import org.neo4j.gds.core.utils.StatementAction;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.kernel.api.KernelTransaction;

public final class RelationshipsScannerTask
extends StatementAction
implements RecordScannerTask {
    private final TerminationFlag terminationFlag;
    private final ProgressTracker progressTracker;
    private final IdMap idMap;
    private final StoreScanner<RelationshipReference> scanner;
    private final int taskIndex;
    private final Collection<SingleTypeRelationshipImporter> singleTypeRelationshipImporters;
    private long relationshipsImported;
    private long weightsImported;

    public static RecordScannerTaskRunner.RecordScannerTaskFactory factory(GraphLoaderContext loadingContext, ProgressTracker progressTracker, IdMap idMap, StoreScanner<RelationshipReference> scanner, Collection<SingleTypeRelationshipImporter> singleTypeRelationshipImporters) {
        return new Factory(loadingContext.transactionContext(), progressTracker, idMap, scanner, singleTypeRelationshipImporters, loadingContext.terminationFlag());
    }

    private RelationshipsScannerTask(TransactionContext tx, TerminationFlag terminationFlag, ProgressTracker progressTracker, IdMap idMap, StoreScanner<RelationshipReference> scanner, int taskIndex, Collection<SingleTypeRelationshipImporter> singleTypeRelationshipImporters) {
        super(tx);
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
        this.idMap = idMap;
        this.scanner = scanner;
        this.taskIndex = taskIndex;
        this.singleTypeRelationshipImporters = singleTypeRelationshipImporters;
    }

    @Override
    public String threadName() {
        return "relationship-store-scan-" + this.taskIndex;
    }

    @Override
    public void accept(KernelTransaction transaction) {
        try (StoreScanner.ScanCursor<RelationshipReference> cursor = this.scanner.createCursor(transaction);){
            List importers = this.singleTypeRelationshipImporters.stream().map(imports -> imports.threadLocalImporter((PartialIdMap)this.idMap, this.scanner.bufferSize(), transaction)).collect(Collectors.toList());
            RecordsBatchBuffer<RelationshipReference> compositeBuffer = CompositeRelationshipsBatchBuffer.of((RelationshipsBatchBuffer[])importers.stream().map(ThreadLocalSingleTypeRelationshipImporter::buffer).toArray(RelationshipsBatchBuffer[]::new));
            long allImportedRels = 0L;
            long allImportedWeights = 0L;
            while (compositeBuffer.scan(cursor)) {
                this.terminationFlag.assertRunning();
                long imported = 0L;
                for (ThreadLocalSingleTypeRelationshipImporter importer : importers) {
                    imported += importer.importRelationships();
                }
                int importedRels = RawValues.getHead(imported);
                int importedWeights = RawValues.getTail(imported);
                this.progressTracker.logProgress(importedRels);
                allImportedRels += (long)importedRels;
                allImportedWeights += (long)importedWeights;
            }
            this.relationshipsImported = allImportedRels;
            this.weightsImported = allImportedWeights;
        }
    }

    @Override
    public long propertiesImported() {
        return this.weightsImported;
    }

    @Override
    public long recordsImported() {
        return this.relationshipsImported;
    }

    static final class Factory
    implements RecordScannerTaskRunner.RecordScannerTaskFactory {
        private final TransactionContext tx;
        private final ProgressTracker progressTracker;
        private final IdMap idMap;
        private final StoreScanner<RelationshipReference> scanner;
        private final Collection<SingleTypeRelationshipImporter> singleTypeRelationshipImporters;
        private final TerminationFlag terminationFlag;

        Factory(TransactionContext tx, ProgressTracker progressTracker, IdMap idMap, StoreScanner<RelationshipReference> scanner, Collection<SingleTypeRelationshipImporter> singleTypeRelationshipImporters, TerminationFlag terminationFlag) {
            this.tx = tx;
            this.progressTracker = progressTracker;
            this.idMap = idMap;
            this.scanner = scanner;
            this.singleTypeRelationshipImporters = singleTypeRelationshipImporters;
            this.terminationFlag = terminationFlag;
        }

        @Override
        public RecordScannerTask create(int taskIndex) {
            return new RelationshipsScannerTask(this.tx, this.terminationFlag, this.progressTracker, this.idMap, this.scanner, taskIndex, this.singleTypeRelationshipImporters);
        }

        @Override
        public Collection<AdjacencyBuffer.AdjacencyListBuilderTask> adjacencyListBuilderTasks() {
            return this.singleTypeRelationshipImporters.stream().flatMap(factory -> factory.adjacencyListBuilderTasks(Optional.empty()).stream()).collect(Collectors.toList());
        }
    }
}

