/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.core.loading.RadixSort;
import org.neo4j.gds.core.loading.RecordsBatchBuffer;
import org.neo4j.gds.core.loading.RelationshipReference;
import org.neo4j.gds.utils.ExceptionUtil;

public final class RelationshipsBatchBuffer
extends RecordsBatchBuffer<RelationshipReference> {
    private final PartialIdMap idMap;
    private final int type;
    private final boolean throwOnUnMappedNodeIds;
    private final long[] relationshipReferences;
    private final PropertyReference[] propertyReferences;
    private final long[] bufferCopy;
    private final long[] relationshipReferencesCopy;
    private final PropertyReference[] propertyReferencesCopy;
    private final int[] histogram;

    public RelationshipsBatchBuffer(PartialIdMap idMap, int type, int capacity) {
        this(idMap, type, capacity, true);
    }

    RelationshipsBatchBuffer(PartialIdMap idMap, int type, int capacity, boolean throwOnUnMappedNodeIds) {
        super(Math.multiplyExact(2, capacity));
        this.idMap = idMap;
        this.type = type;
        this.throwOnUnMappedNodeIds = throwOnUnMappedNodeIds;
        this.relationshipReferences = new long[capacity];
        this.propertyReferences = new PropertyReference[capacity];
        this.bufferCopy = RadixSort.newCopy(this.buffer);
        this.relationshipReferencesCopy = RadixSort.newCopy(this.relationshipReferences);
        this.propertyReferencesCopy = RadixSort.newCopy(this.propertyReferences);
        this.histogram = RadixSort.newHistogram(capacity);
    }

    @Override
    public void offer(RelationshipReference record) {
        if (this.type == -1 || this.type == record.typeTokenId()) {
            long source = this.idMap.toMappedNodeId(record.sourceNodeReference());
            long target = this.idMap.toMappedNodeId(record.targetNodeReference());
            if (this.throwOnUnMappedNodeIds) {
                ExceptionUtil.validateSourceNodeIsLoaded(source, record.sourceNodeReference());
                ExceptionUtil.validateTargetNodeIsLoaded(target, record.targetNodeReference());
            } else if (source == -1L || target == -1L) {
                return;
            }
            this.add(source, target, record.relationshipId(), record.propertiesReference());
        }
    }

    public void add(long sourceId, long targetId) {
        int position = this.length;
        long[] buffer = this.buffer;
        buffer[position] = sourceId;
        buffer[1 + position] = targetId;
        this.length = 2 + position;
    }

    public void add(long sourceId, long targetId, long relationshipReference, PropertyReference propertyReference) {
        int position = this.length;
        long[] buffer = this.buffer;
        buffer[position] = sourceId;
        buffer[1 + position] = targetId;
        this.relationshipReferences[position >> 1] = relationshipReference;
        this.propertyReferences[position >> 1] = propertyReference;
        this.length = 2 + position;
    }

    public long[] sortBySource() {
        RadixSort.radixSort(this.buffer, this.bufferCopy, this.relationshipReferences, this.relationshipReferencesCopy, this.propertyReferences, this.propertyReferencesCopy, this.histogram, this.length);
        return this.buffer;
    }

    public long[] sortByTarget() {
        RadixSort.radixSort2(this.buffer, this.bufferCopy, this.relationshipReferences, this.relationshipReferencesCopy, this.propertyReferences, this.propertyReferencesCopy, this.histogram, this.length);
        return this.buffer;
    }

    long[] relationshipReferences() {
        return this.relationshipReferences;
    }

    PropertyReference[] propertyReferences() {
        return this.propertyReferences;
    }

    public long[] spareLongs() {
        return this.bufferCopy;
    }

    public int[] spareInts() {
        return this.histogram;
    }
}

