/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.ImmutableProperties;
import org.neo4j.gds.api.ImmutableTopology;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.ValueTypes;
import org.neo4j.gds.core.compress.AdjacencyListsWithProperties;
import org.neo4j.gds.core.loading.ImmutableRelationshipTypeAndProjection;
import org.neo4j.gds.core.loading.ImmutableRelationshipsAndProperties;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.values.storable.NumberType;

@ValueClass
public interface RelationshipsAndProperties {
    public Map<RelationshipType, Relationships.Topology> relationships();

    public Map<RelationshipType, RelationshipPropertyStore> properties();

    public static RelationshipsAndProperties of(Map<RelationshipTypeAndProjection, List<Relationships>> relationshipsByType) {
        int relTypeCount = relationshipsByType.size();
        HashMap topologies = new HashMap(relTypeCount);
        HashMap relationshipPropertyStores = new HashMap(relTypeCount);
        relationshipsByType.forEach((relationshipTypeAndProjection, relationships) -> {
            Relationships.Topology topology = ((Relationships)relationships.get(0)).topology();
            List<AdjacencyProperties> properties = relationships.stream().map(Relationships::properties).map(props -> props.map(Relationships.Properties::propertiesList)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            RelationshipPropertyStore propertyStore = RelationshipsAndProperties.constructRelationshipPropertyStore(relationshipTypeAndProjection.relationshipProjection(), properties, topology.elementCount());
            topologies.put(relationshipTypeAndProjection.relationshipType(), topology);
            relationshipPropertyStores.put(relationshipTypeAndProjection.relationshipType(), propertyStore);
        });
        return ImmutableRelationshipsAndProperties.builder().relationships(topologies).properties(relationshipPropertyStores).build();
    }

    public static RelationshipsAndProperties of(Collection<SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext> builders) {
        int relTypeCount = builders.size();
        HashMap relationships = new HashMap(relTypeCount);
        HashMap relationshipPropertyStores = new HashMap(relTypeCount);
        builders.forEach(context -> {
            AdjacencyListsWithProperties adjacencyListsWithProperties = context.singleTypeRelationshipImporter().build();
            AdjacencyList adjacency = adjacencyListsWithProperties.adjacency();
            List<AdjacencyProperties> properties = adjacencyListsWithProperties.properties();
            long relationshipCount = adjacencyListsWithProperties.relationshipCount();
            RelationshipProjection projection = context.relationshipProjection();
            relationships.put(context.relationshipType(), ImmutableTopology.of(adjacency, relationshipCount, projection.orientation(), projection.isMultiGraph()));
            if (!projection.properties().isEmpty()) {
                relationshipPropertyStores.put(context.relationshipType(), RelationshipsAndProperties.constructRelationshipPropertyStore(projection, properties, relationshipCount));
            }
        });
        return ImmutableRelationshipsAndProperties.builder().relationships(relationships).properties(relationshipPropertyStores).build();
    }

    private static RelationshipPropertyStore constructRelationshipPropertyStore(RelationshipProjection projection, Iterable<AdjacencyProperties> properties, long relationshipCount) {
        PropertyMappings propertyMappings = projection.properties();
        RelationshipPropertyStore.Builder propertyStoreBuilder = RelationshipPropertyStore.builder();
        Iterator<AdjacencyProperties> propertiesIter = properties.iterator();
        propertyMappings.mappings().forEach(propertyMapping -> {
            AdjacencyProperties propertiesList = (AdjacencyProperties)propertiesIter.next();
            propertyStoreBuilder.putIfAbsent(propertyMapping.propertyKey(), RelationshipProperty.of(propertyMapping.propertyKey(), NumberType.FLOATING_POINT, PropertyState.PERSISTENT, ImmutableProperties.of(propertiesList, relationshipCount, projection.orientation(), projection.isMultiGraph(), propertyMapping.defaultValue().doubleValue()), propertyMapping.defaultValue().isUserDefined() ? propertyMapping.defaultValue() : ValueTypes.fromNumberType(NumberType.FLOATING_POINT).fallbackValue(), propertyMapping.aggregation()));
        });
        return propertyStoreBuilder.build();
    }

    @ValueClass
    public static interface RelationshipTypeAndProjection {
        public RelationshipType relationshipType();

        public RelationshipProjection relationshipProjection();

        public static RelationshipTypeAndProjection of(RelationshipType relationshipType, RelationshipProjection relationshipProjection) {
            return ImmutableRelationshipTypeAndProjection.of(relationshipType, relationshipProjection);
        }
    }
}

