/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Set;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.CypherRelationshipLoader;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.utils.ExceptionUtil;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.TextValue;

class RelationshipSubscriber
implements QuerySubscriber {
    private static final String SOURCE_COLUMN = "source";
    private static final String TARGET_COLUMN = "target";
    private static final int UNINITIALIZED = -1;
    static final String TYPE_COLUMN = "type";
    static final Set<String> REQUIRED_COLUMNS = Set.of("source", "target");
    static final Set<String> RESERVED_COLUMNS = Set.of("source", "target", "type");
    private final IdMap idMap;
    private final CypherRelationshipLoader.Context loaderContext;
    private final ProgressTracker progressTracker;
    private double[] propertyValueBuffer;
    private double[] defaultValues;
    private final boolean throwOnUnMappedNodeIds;
    private int sourceOffset = -1;
    private int targetOffset = -1;
    private int typeOffset = -1;
    private long lastNeoSourceId = -1L;
    private long lastNeoTargetId = -1L;
    private long sourceId = -1L;
    private long targetId = -1L;
    private long rows = 0L;
    private RelationshipType relationshipType = RelationshipType.ALL_RELATIONSHIPS;
    private int propertyIndex = 0;
    private RelationshipsBuilder allRelationshipsBuilder;

    RelationshipSubscriber(IdMap idMap, CypherRelationshipLoader.Context loaderContext, boolean throwOnUnMappedNodeIds, ProgressTracker progressTracker) {
        this.idMap = idMap;
        this.progressTracker = progressTracker;
        this.loaderContext = loaderContext;
        this.throwOnUnMappedNodeIds = throwOnUnMappedNodeIds;
    }

    void initialize(String[] fieldNames, ObjectDoubleMap<String> propertyDefaultValueByName) {
        this.defaultValues = new double[fieldNames.length];
        block10: for (int i = 0; i < fieldNames.length; ++i) {
            switch (fieldNames[i]) {
                case "source": {
                    this.sourceOffset = i;
                    continue block10;
                }
                case "target": {
                    this.targetOffset = i;
                    continue block10;
                }
                case "type": {
                    this.typeOffset = i;
                    continue block10;
                }
                default: {
                    this.defaultValues[i] = propertyDefaultValueByName.get((Object)fieldNames[i]);
                }
            }
        }
        int propertyCount = fieldNames.length - 2;
        if (this.typeOffset != -1) {
            --propertyCount;
        } else {
            this.allRelationshipsBuilder = this.loaderContext.getOrCreateRelationshipsBuilder(RelationshipType.ALL_RELATIONSHIPS);
        }
        this.propertyValueBuffer = new double[propertyCount];
    }

    public long rows() {
        return this.rows;
    }

    public void onResult(int numberOfFields) {
    }

    public void onRecord() {
        this.propertyIndex = 0;
    }

    public void onField(int offset, AnyValue value) {
        if (offset == this.sourceOffset) {
            this.onSourceNode((NumberValue)value);
        } else if (offset == this.targetOffset) {
            this.onTargetNode((NumberValue)value);
        } else if (offset == this.typeOffset) {
            this.relationshipType = RelationshipType.of((String)((TextValue)value).stringValue());
        } else {
            this.propertyValueBuffer[this.propertyIndex++] = this.readPropertyValue(value, offset);
        }
    }

    private void onTargetNode(NumberValue value) {
        long neoTargetId = value.longValue();
        if (neoTargetId != this.lastNeoTargetId) {
            this.targetId = this.idMap.toMappedNodeId(neoTargetId);
            if (this.throwOnUnMappedNodeIds) {
                ExceptionUtil.validateTargetNodeIsLoaded(this.targetId, neoTargetId);
            }
            this.lastNeoTargetId = neoTargetId;
        }
    }

    private void onSourceNode(NumberValue value) {
        long neoSourceId = value.longValue();
        if (neoSourceId != this.lastNeoSourceId) {
            this.sourceId = this.idMap.toMappedNodeId(neoSourceId);
            if (this.throwOnUnMappedNodeIds) {
                ExceptionUtil.validateSourceNodeIsLoaded(this.sourceId, neoSourceId);
            }
            this.lastNeoSourceId = neoSourceId;
        }
    }

    private double readPropertyValue(AnyValue value, int offset) {
        if (value instanceof NumberValue) {
            return ((NumberValue)value).doubleValue();
        }
        return this.defaultValues[offset];
    }

    public void onRecordCompleted() {
        RelationshipsBuilder relationshipsBuilder;
        ++this.rows;
        if (!(this.throwOnUnMappedNodeIds || this.sourceId != -1L && this.targetId != -1L)) {
            return;
        }
        RelationshipsBuilder relationshipsBuilder2 = relationshipsBuilder = this.allRelationshipsBuilder != null ? this.allRelationshipsBuilder : this.loaderContext.getOrCreateRelationshipsBuilder(this.relationshipType);
        if (this.propertyValueBuffer.length == 0) {
            relationshipsBuilder.addFromInternal(this.sourceId, this.targetId);
        } else if (this.propertyValueBuffer.length == 1) {
            relationshipsBuilder.addFromInternal(this.sourceId, this.targetId, this.propertyValueBuffer[0]);
        } else {
            relationshipsBuilder.addFromInternal(this.sourceId, this.targetId, this.propertyValueBuffer);
        }
        this.progressTracker.logProgress();
    }

    public void onError(Throwable throwable) {
        throw new RuntimeException(throwable);
    }

    public void onResultCompleted(QueryStatistics statistics) {
    }
}

