/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.AbstractCursorBasedScanner;
import org.neo4j.gds.core.loading.RelationshipReference;
import org.neo4j.gds.core.loading.RelationshipScanCursorReference;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.kernel.api.KernelTransaction;

public final class RelationshipScanCursorBasedScanner
extends AbstractCursorBasedScanner<RelationshipReference, RelationshipScanCursor> {
    public static final StoreScanner.Factory<RelationshipReference> FACTORY = RelationshipScanCursorBasedScanner::new;

    private RelationshipScanCursorBasedScanner(int prefetchSize, TransactionContext transaction) {
        super(prefetchSize, transaction);
    }

    @Override
    int recordsPerPage() {
        return 240;
    }

    @Override
    public long storeSize(GraphDimensions graphDimensions) {
        long recordsInUse = 1L + graphDimensions.highestRelationshipId();
        long idsInPages = (recordsInUse + ((long)this.recordsPerPage() - 1L)) / (long)this.recordsPerPage() * (long)this.recordsPerPage();
        return idsInPages * 34L;
    }

    @Override
    RelationshipScanCursor entityCursor(KernelTransaction transaction) {
        return Neo4jProxy.allocateRelationshipScanCursor((KernelTransaction)transaction);
    }

    @Override
    StoreScan<RelationshipScanCursor> entityCursorScan(KernelTransaction transaction) {
        return Neo4jProxy.scanToStoreScan((Scan)transaction.dataRead().allRelationshipsScan(), (int)this.batchSize());
    }

    @Override
    RelationshipReference cursorReference(KernelTransaction transaction, RelationshipScanCursor cursor) {
        return new RelationshipScanCursorReference(cursor);
    }

    @Override
    void closeCursorReference(RelationshipReference relationshipReference) {
    }
}

