/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.core.loading.StoreScanner;

public abstract class RecordsBatchBuffer<Reference>
implements StoreScanner.RecordConsumer<Reference> {
    public static final int DEFAULT_BUFFER_SIZE = 100000;
    final long[] buffer;
    int length;

    RecordsBatchBuffer(int capacity) {
        this.buffer = new long[capacity];
    }

    public boolean scan(StoreScanner.ScanCursor<Reference> cursor) {
        this.reset();
        return cursor.bulkNext(this);
    }

    public int length() {
        return this.length;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public boolean isFull() {
        return this.length >= this.buffer.length;
    }

    public void reset() {
        this.length = 0;
    }

    public long[] batch() {
        return this.buffer;
    }
}

