/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.ImmutableImportResult;
import org.neo4j.gds.core.loading.RecordScannerTask;

final class RecordScannerTaskRunner {
    private final int threadCount;
    private final RecordScannerTaskFactory recordScannerTaskFactory;

    RecordScannerTaskRunner(int threadCount, RecordScannerTaskFactory recordScannerTaskFactory) {
        this.threadCount = threadCount;
        this.recordScannerTaskFactory = recordScannerTaskFactory;
    }

    ImportResult runImport(ExecutorService executorService) {
        ArrayList<RecordScannerTask> tasks = new ArrayList<RecordScannerTask>(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            tasks.add(this.recordScannerTaskFactory.create(i));
        }
        long start = System.nanoTime();
        ParallelUtil.run(tasks, executorService);
        ParallelUtil.run(this.recordScannerTaskFactory.adjacencyListBuilderTasks(), executorService);
        long elapsed = System.nanoTime() - start;
        long importedRecords = 0L;
        long importedProperties = 0L;
        for (RecordScannerTask task : tasks) {
            importedRecords += task.recordsImported();
            importedProperties += task.propertiesImported();
        }
        return ImmutableImportResult.builder().importedRecords(importedRecords).importedProperties(importedProperties).durationNanos(elapsed).build();
    }

    public static interface RecordScannerTaskFactory {
        public RecordScannerTask create(int var1);

        public Collection<AdjacencyBuffer.AdjacencyListBuilderTask> adjacencyListBuilderTasks();
    }

    @ValueClass
    static interface ImportResult {
        public long durationNanos();

        public long importedRecords();

        public long importedProperties();
    }
}

