/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class ReadHelper {
    private ReadHelper() {
        throw new UnsupportedOperationException("No instances");
    }

    public static void readProperties(PropertyCursor pc, int[] propertyIds, double[] defaultValues, Aggregation[] aggregations, double[] properties) {
        Arrays.setAll(properties, indexOfPropertyId -> {
            double defaultValue = defaultValues[indexOfPropertyId];
            Aggregation aggregation = aggregations[indexOfPropertyId];
            if (propertyIds[indexOfPropertyId] == -1) {
                return aggregation.normalizePropertyValue(defaultValue);
            }
            return aggregation.emptyValue(defaultValue);
        });
        while (pc.next()) {
            for (int indexOfPropertyId2 = 0; indexOfPropertyId2 < propertyIds.length; ++indexOfPropertyId2) {
                double propertyValue;
                if (propertyIds[indexOfPropertyId2] != pc.propertyKey()) continue;
                Aggregation aggregation = aggregations[indexOfPropertyId2];
                Value value = pc.propertyValue();
                double defaultValue = defaultValues[indexOfPropertyId2];
                properties[indexOfPropertyId2] = propertyValue = ReadHelper.extractValue(aggregation, value, defaultValue);
            }
        }
    }

    public static double extractValue(Value value, double defaultValue) {
        return ReadHelper.extractValue(Aggregation.NONE, value, defaultValue);
    }

    public static double extractValue(Aggregation aggregation, Value value, double defaultValue) {
        if (value instanceof NumberValue) {
            double propertyValue = ((NumberValue)value).doubleValue();
            return aggregation.normalizePropertyValue(propertyValue);
        }
        if (Values.NO_VALUE.equals(value)) {
            return aggregation.emptyValue(defaultValue);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported type [%s] of value %s. Please use a numeric property.", (Object[])new Object[]{value.valueGroup(), value}));
    }
}

