/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import java.util.Arrays;
import java.util.function.LongSupplier;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.compress.LongArrayBuffer;
import org.neo4j.gds.core.loading.AbstractAdjacencyCompressorFactory;
import org.neo4j.gds.core.loading.AdjacencyCompression;
import org.neo4j.gds.core.loading.AdjacencyListBuilder;
import org.neo4j.gds.core.loading.AdjacencyListBuilderFactory;
import org.neo4j.gds.core.utils.AscendingLongComparator;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class RawCompressor
implements AdjacencyCompressor {
    private final AdjacencyListBuilder.Allocator<long[]> adjacencyAllocator;
    private final AdjacencyListBuilder.Allocator<long[]>[] propertiesAllocators;
    private final HugeIntArray adjacencyDegrees;
    private final HugeLongArray adjacencyOffsets;
    private final HugeLongArray propertyOffsets;
    private final boolean noAggregation;
    private final Aggregation[] aggregations;

    public static AdjacencyCompressorFactory factory(LongSupplier nodeCountSupplier, AdjacencyListBuilderFactory<long[], ? extends AdjacencyList, long[], ? extends AdjacencyProperties> adjacencyListBuilderFactory, PropertyMappings propertyMappings, Aggregation[] aggregations, boolean noAggregation) {
        AdjacencyListBuilder[] propertyBuilders = new AdjacencyListBuilder[propertyMappings.numberOfMappings()];
        Arrays.setAll(propertyBuilders, i -> adjacencyListBuilderFactory.newAdjacencyPropertiesBuilder());
        return new Factory(nodeCountSupplier, adjacencyListBuilderFactory.newAdjacencyListBuilder(), propertyBuilders, noAggregation, aggregations);
    }

    private RawCompressor(AdjacencyListBuilder.Allocator<long[]> adjacencyAllocator, AdjacencyListBuilder.Allocator<long[]>[] propertiesAllocators, HugeIntArray adjacencyDegrees, HugeLongArray adjacencyOffsets, HugeLongArray propertyOffsets, boolean noAggregation, Aggregation[] aggregations) {
        this.adjacencyAllocator = adjacencyAllocator;
        this.propertiesAllocators = propertiesAllocators;
        this.adjacencyDegrees = adjacencyDegrees;
        this.adjacencyOffsets = adjacencyOffsets;
        this.propertyOffsets = propertyOffsets;
        this.noAggregation = noAggregation;
        this.aggregations = aggregations;
    }

    @Override
    public int compress(long nodeId, byte[] targets, long[][] properties, int numberOfCompressedTargets, int compressedBytesSize, LongArrayBuffer buffer, AdjacencyCompressor.ValueMapper mapper) {
        if (properties != null) {
            return this.withProperties(nodeId, targets, properties, numberOfCompressedTargets, compressedBytesSize, buffer, mapper);
        }
        return this.withoutProperties(nodeId, targets, numberOfCompressedTargets, compressedBytesSize, buffer, mapper);
    }

    @Override
    public void close() {
        this.adjacencyAllocator.close();
        for (AdjacencyListBuilder.Allocator<long[]> propertiesAllocator : this.propertiesAllocators) {
            if (propertiesAllocator == null) continue;
            propertiesAllocator.close();
        }
    }

    private int withoutProperties(long nodeId, byte[] targets, int numberOfCompressedTargets, int compressedBytesSize, LongArrayBuffer buffer, AdjacencyCompressor.ValueMapper mapper) {
        AdjacencyCompression.copyFrom(buffer, targets, numberOfCompressedTargets, compressedBytesSize, mapper);
        int degree = this.aggregate(buffer, this.aggregations[0]);
        long address = this.copy(buffer.buffer, degree, this.adjacencyAllocator);
        this.adjacencyDegrees.set(nodeId, degree);
        this.adjacencyOffsets.set(nodeId, address);
        return degree;
    }

    private int aggregate(LongArrayBuffer targets, Aggregation aggregation) {
        long[] values = targets.buffer;
        int length = targets.length;
        Arrays.sort(values, 0, length);
        if (aggregation == Aggregation.NONE) {
            return length;
        }
        int write = 1;
        for (int read = 1; read < length; ++read) {
            long value = values[read];
            if (value == values[read - 1]) continue;
            values[write++] = value;
        }
        return write;
    }

    private int aggregateWithProperties(LongArrayBuffer targets, long[][] properties, Aggregation[] aggregations) {
        int i;
        int sortIdx;
        int in;
        long value;
        long[] values = targets.buffer;
        int length = targets.length;
        int[] order = IndirectSort.mergesort((int)0, (int)length, (IndirectComparator)new AscendingLongComparator(values));
        long[] outValues = new long[length];
        long[][] outProperties = new long[properties.length][length];
        int firstSortIdx = order[0];
        outValues[0] = value = values[firstSortIdx];
        for (int i2 = 0; i2 < properties.length; ++i2) {
            outProperties[i2][0] = properties[i2][firstSortIdx];
        }
        int out = 1;
        if (this.noAggregation) {
            for (in = 1; in < length; ++in) {
                sortIdx = order[in];
                for (i = 0; i < properties.length; ++i) {
                    outProperties[i][out] = properties[i][sortIdx];
                }
                outValues[out++] = values[sortIdx];
            }
        } else {
            while (in < length) {
                sortIdx = order[in];
                long delta = values[sortIdx] - value;
                value = values[sortIdx];
                if (delta > 0L) {
                    for (i = 0; i < properties.length; ++i) {
                        outProperties[i][out] = properties[i][sortIdx];
                    }
                    outValues[out++] = value;
                } else {
                    for (i = 0; i < properties.length; ++i) {
                        Aggregation aggregation = aggregations[i];
                        int existingIdx = out - 1;
                        long[] outProperty = outProperties[i];
                        double existingProperty = Double.longBitsToDouble(outProperty[existingIdx]);
                        double newProperty = Double.longBitsToDouble(properties[i][sortIdx]);
                        newProperty = aggregation.merge(existingProperty, newProperty);
                        outProperty[existingIdx] = Double.doubleToLongBits(newProperty);
                    }
                }
                ++in;
            }
        }
        System.arraycopy(outValues, 0, values, 0, out);
        for (int i3 = 0; i3 < outProperties.length; ++i3) {
            System.arraycopy(outProperties[i3], 0, properties[i3], 0, out);
        }
        return out;
    }

    private int withProperties(long nodeId, byte[] targets, long[][] uncompressedProperties, int numberOfCompressedTargets, int compressedBytesSize, LongArrayBuffer buffer, AdjacencyCompressor.ValueMapper mapper) {
        AdjacencyCompression.copyFrom(buffer, targets, numberOfCompressedTargets, compressedBytesSize, mapper);
        int degree = this.aggregateWithProperties(buffer, uncompressedProperties, this.aggregations);
        long address = this.copy(buffer.buffer, degree, this.adjacencyAllocator);
        this.copyProperties(uncompressedProperties, degree, nodeId, this.propertyOffsets);
        this.adjacencyDegrees.set(nodeId, degree);
        this.adjacencyOffsets.set(nodeId, address);
        return degree;
    }

    private void copyProperties(long[][] properties, int degree, long nodeId, HugeLongArray offsets) {
        long offset = this.propertiesAllocators[0].write(properties[0], degree, -1L);
        for (int i = 1; i < properties.length; ++i) {
            this.propertiesAllocators[i].write(properties[i], degree, offset);
        }
        offsets.set(nodeId, offset);
    }

    private long copy(long[] data, int degree, AdjacencyListBuilder.Allocator<long[]> allocator) {
        return allocator.write(data, degree, -1L);
    }

    private static final class Factory
    extends AbstractAdjacencyCompressorFactory<long[], long[]> {
        Factory(LongSupplier nodeCountSupplier, AdjacencyListBuilder<long[], ? extends AdjacencyList> adjacencyBuilder, AdjacencyListBuilder<long[], ? extends AdjacencyProperties>[] propertyBuilders, boolean noAggregation, Aggregation[] aggregations) {
            super(nodeCountSupplier, adjacencyBuilder, propertyBuilders, noAggregation, aggregations);
        }

        @Override
        public RawCompressor createCompressor() {
            AdjacencyListBuilder.Allocator[] propertyAllocators = new AdjacencyListBuilder.Allocator[this.propertyBuilders.length];
            Arrays.setAll(propertyAllocators, i -> i == 0 ? this.propertyBuilders[i].newAllocator() : this.propertyBuilders[i].newPositionalAllocator());
            return new RawCompressor(this.adjacencyBuilder.newAllocator(), propertyAllocators, this.adjacencyDegrees, this.adjacencyOffsets, this.propertyOffsets, this.noAggregation, this.aggregations);
        }
    }
}

